/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.config;

import io.datarouter.loadtest.config.DatarouterLoadTestPaths;
import io.datarouter.loadtest.config.DatarouterLoadTestRouteSet;
import io.datarouter.loadtest.service.LoadTestGetDao;
import io.datarouter.loadtest.service.LoadTestInsertDao;
import io.datarouter.loadtest.service.LoadTestScanDao;
import io.datarouter.loadtest.storage.DatarouterLoadTestGetDao;
import io.datarouter.loadtest.storage.DatarouterLoadTestInsertDao;
import io.datarouter.loadtest.storage.DatarouterLoadTestScanDao;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.ArrayList;
import java.util.List;

public class DatarouterLoadTestPlugin
extends BaseWebPlugin {
    private static final DatarouterLoadTestPaths PATHS = new DatarouterLoadTestPaths();
    private final ClientId loadTestGetClientId;
    private final ClientId loadTestInsertClientId;
    private final ClientId loadTestScanClientId;

    private DatarouterLoadTestPlugin(DatarouterLoadTestDaosModule daosModule, ClientId loadTestGetClientId, ClientId loadTestInsertClientId, ClientId loadTestScanClientId) {
        this.loadTestGetClientId = loadTestGetClientId;
        this.loadTestInsertClientId = loadTestInsertClientId;
        this.loadTestScanClientId = loadTestScanClientId;
        this.addRouteSet(DatarouterLoadTestRouteSet.class);
        if (loadTestGetClientId != null) {
            this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.TOOLS, DatarouterLoadTestPlugin.PATHS.datarouter.loadTest.get, "LoadTest - Get");
        }
        if (loadTestInsertClientId != null) {
            this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.TOOLS, DatarouterLoadTestPlugin.PATHS.datarouter.loadTest.insert, "LoadTest - Insert");
        }
        if (loadTestScanClientId != null) {
            this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.TOOLS, DatarouterLoadTestPlugin.PATHS.datarouter.loadTest.scan, "LoadTest - Scan");
        }
        this.setDaosModule(daosModule);
    }

    public String getName() {
        return "DatarouterLoadTest";
    }

    protected void configure() {
        if (this.loadTestGetClientId == null) {
            this.bind(LoadTestGetDao.class).to(LoadTestGetDao.NoOpLoadTestGetDao.class);
        } else {
            this.bind(LoadTestGetDao.class).to(DatarouterLoadTestGetDao.class);
        }
        if (this.loadTestInsertClientId == null) {
            this.bind(LoadTestInsertDao.class).to(LoadTestInsertDao.NoOpLoadTestInsertDao.class);
        } else {
            this.bind(LoadTestInsertDao.class).to(DatarouterLoadTestInsertDao.class);
        }
        if (this.loadTestScanClientId == null) {
            this.bind(LoadTestScanDao.class).to(LoadTestScanDao.NoOpLoadTestScanDao.class);
        } else {
            this.bind(LoadTestScanDao.class).to(DatarouterLoadTestScanDao.class);
        }
    }

    private static class DatarouterLoadTestDaosModule
    extends DaosModuleBuilder {
        private final ClientId loadTestGetClientId;
        private final ClientId loadTestInsertClientId;
        private final ClientId loadTestScanClientId;

        private DatarouterLoadTestDaosModule(ClientId loadTestGetClientId, ClientId loadTestInsertClientId, ClientId loadTestScanClientId) {
            this.loadTestGetClientId = loadTestGetClientId;
            this.loadTestInsertClientId = loadTestInsertClientId;
            this.loadTestScanClientId = loadTestScanClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            ArrayList<Class<? extends Dao>> daos = new ArrayList<Class<? extends Dao>>();
            if (this.loadTestGetClientId != null) {
                daos.add(DatarouterLoadTestGetDao.class);
            }
            if (this.loadTestInsertClientId != null) {
                daos.add(DatarouterLoadTestInsertDao.class);
            }
            if (this.loadTestScanClientId != null) {
                daos.add(DatarouterLoadTestScanDao.class);
            }
            return daos;
        }

        protected void configure() {
            if (this.loadTestGetClientId != null) {
                this.bind(DatarouterLoadTestGetDao.DatarouterLoadTestGetDaoParams.class).toInstance((Object)new DatarouterLoadTestGetDao.DatarouterLoadTestGetDaoParams(this.loadTestGetClientId));
            }
            if (this.loadTestInsertClientId != null) {
                this.bind(DatarouterLoadTestInsertDao.DatarouterLoadTestInsertDaoParams.class).toInstance((Object)new DatarouterLoadTestInsertDao.DatarouterLoadTestInsertDaoParams(this.loadTestInsertClientId));
            }
            if (this.loadTestScanClientId != null) {
                this.bind(DatarouterLoadTestScanDao.DatarouterLoadTestScanDaoParams.class).toInstance((Object)new DatarouterLoadTestScanDao.DatarouterLoadTestScanDaoParams(this.loadTestScanClientId));
            }
        }
    }

    public static class DatarouterLoadTestPluginBuilder {
        private ClientId loadTestGetClientId;
        private ClientId loadTestInsertClientId;
        private ClientId loadTestScanClientId;

        public DatarouterLoadTestPluginBuilder setLoadTestGetClientId(ClientId loadTestGetClientId) {
            this.loadTestGetClientId = loadTestGetClientId;
            return this;
        }

        public DatarouterLoadTestPluginBuilder setLoadTestInsertClientId(ClientId loadTestInsertClientId) {
            this.loadTestInsertClientId = loadTestInsertClientId;
            return this;
        }

        public DatarouterLoadTestPluginBuilder setLoadTestScanClientId(ClientId loadTestScanClientId) {
            this.loadTestScanClientId = loadTestScanClientId;
            return this;
        }

        public DatarouterLoadTestPlugin build() {
            DatarouterLoadTestDaosModule daosModule = new DatarouterLoadTestDaosModule(this.loadTestGetClientId, this.loadTestInsertClientId, this.loadTestScanClientId);
            return new DatarouterLoadTestPlugin(daosModule, this.loadTestGetClientId, this.loadTestInsertClientId, this.loadTestScanClientId);
        }
    }
}

