/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.web;

import io.datarouter.loadtest.service.LoadTestScanDao;
import io.datarouter.loadtest.storage.RandomValue;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.timer.PhaseTimer;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.form.HtmlFormNumber;
import io.datarouter.web.html.form.HtmlFormSubmitActionButton;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTestScanHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoadTestScanHandler.class);
    private static final String P_num = "num";
    private static final String P_batchSize = "batchSize";
    private static final String P_submitAction = "submitAction";
    private static final int DEFAULT_NUM = 100000;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    @Inject
    private LoadTestScanDao dao;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav scan(@Param(value="num") Optional<String> num, @Param(value="batchSize") Optional<String> batchSize, @Param(value="submitAction") Optional<String> submitAction) {
        HtmlForm form = new HtmlForm(HtmlForm.HtmlFormMethod.POST);
        ((HtmlFormNumber)((HtmlFormNumber)form.addNumberField().withLabel("Num")).withName(P_num)).withPlaceholder((Number)100000).withValue((String)num.orElse(null));
        ((HtmlFormNumber)((HtmlFormNumber)form.addNumberField().withLabel("Batch Size")).withName(P_batchSize)).withPlaceholder((Number)100).withValue((String)batchSize.orElse(null));
        ((HtmlFormSubmitActionButton)form.addButton().withLabel("Run Scan")).withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Load Test - Scan").withContent((DomContent)Html.makeContent(form)).buildMav();
        }
        PhaseTimer timer = new PhaseTimer("scan");
        int pNum = num.map(StringTool::nullIfEmpty).map(number -> number.replace(",", "")).map(Integer::valueOf).orElse(100000);
        int pBatchSize = batchSize.map(StringTool::nullIfEmpty).map(number -> number.replace(",", "")).map(Integer::valueOf).orElse(1000);
        AtomicInteger rowCounter = new AtomicInteger(0);
        AtomicLong lastBatchFinished = new AtomicLong(System.nanoTime());
        this.dao.scan(pBatchSize, pNum).forEach(randomValue -> LoadTestScanHandler.trackEachRow(rowCounter, lastBatchFinished, randomValue));
        timer.add("scanned " + rowCounter.get());
        Tag message = TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Load Test Scan Results"), TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Results"), TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Total Time"), TagCreator.dd((String)timer.getElapsedString()), TagCreator.dt((String)"Rows per second"), TagCreator.dd((String)("" + timer.getItemsPerSecond((long)rowCounter.get())))})}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Params"), TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Num"), TagCreator.dd((String)("" + pNum)), TagCreator.dt((String)"Batch Size"), TagCreator.dd((String)("" + pBatchSize))})})}).withClass("container");
        logger.warn("total={}, rps={}, num={}, batchSize={}", new Object[]{timer.getElapsedString(), Float.valueOf(timer.getItemsPerSecond((long)rowCounter.get())), pNum, pBatchSize});
        return this.pageFactory.message(this.request, (DomContent)message);
    }

    private static void trackEachRow(AtomicInteger rowCounter, AtomicLong lastBatchFinished, RandomValue lastRow) {
        int logBatchSize;
        int count = rowCounter.incrementAndGet();
        if (count % (logBatchSize = 1000) == 0) {
            long durationNs = System.nanoTime() - lastBatchFinished.get();
            double rpNs = (double)logBatchSize / (double)durationNs;
            double rps = rpNs * 1000.0 * 1000.0 * 1000.0;
            logger.warn("scanned {} @{}rps from {}", new Object[]{NumberFormatter.addCommas((Number)rowCounter), NumberFormatter.addCommas((Number)rps), NumberFormatter.addCommas((Number)lastRow.getK())});
            lastBatchFinished.set(System.nanoTime());
        }
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(HtmlForm htmlForm) {
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Load Test - Scan"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

