/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.web;

import io.datarouter.loadtest.service.LoadTestGetDao;
import io.datarouter.loadtest.storage.RandomValue;
import io.datarouter.loadtest.storage.RandomValueKey;
import io.datarouter.loadtest.util.LoadTestTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.util.concurrent.CallableTool;
import io.datarouter.util.concurrent.ExecutorServiceTool;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.timer.PhaseTimer;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.form.HtmlFormNumber;
import io.datarouter.web.html.form.HtmlFormSubmitActionButton;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTestGetHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoadTestGetHandler.class);
    private static final String P_num = "num";
    private static final String P_max = "max";
    private static final String P_numThreads = "numThreads";
    private static final String P_batchSize = "batchSize";
    private static final String P_logPeriod = "logPeriod";
    private static final String P_submitAction = "submitAction";
    private static final int DEFAULT_NUM = 100000;
    private static final int DEFAULT_NUM_THREADS = 10;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final int DEFAULT_LOG_PERIOD = 10000;
    @Inject
    private LoadTestGetDao dao;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav get(@Param(value="num") Optional<String> num, @Param(value="max") Optional<String> max, @Param(value="numThreads") Optional<String> numThreads, @Param(value="batchSize") Optional<String> batchSize, @Param(value="logPeriod") Optional<String> logPeriod, @Param(value="submitAction") Optional<String> submitAction) {
        HtmlForm form = new HtmlForm(HtmlForm.HtmlFormMethod.POST);
        ((HtmlFormNumber)((HtmlFormNumber)form.addNumberField().withLabel("Num")).withName(P_num)).withPlaceholder((Number)100000).withValue((String)num.orElse(null));
        ((HtmlFormNumber)((HtmlFormNumber)form.addNumberField().withLabel("Max")).withName(P_max)).withPlaceholder((Number)10).withValue((String)max.orElse(null));
        ((HtmlFormNumber)((HtmlFormNumber)form.addNumberField().withLabel("Num Threads")).withName(P_numThreads)).withPlaceholder((Number)10).withValue((String)numThreads.orElse(null));
        ((HtmlFormNumber)((HtmlFormNumber)form.addNumberField().withLabel("Batch Size")).withName(P_batchSize)).withPlaceholder((Number)100).withValue((String)batchSize.orElse(null));
        ((HtmlFormNumber)((HtmlFormNumber)form.addNumberField().withLabel("Log Period")).withName(P_logPeriod)).withPlaceholder((Number)10000).withValue((String)logPeriod.orElse(null));
        ((HtmlFormSubmitActionButton)form.addButton().withLabel("Run Get")).withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Load Test - Get").withContent((DomContent)Html.makeContent(form)).buildMav();
        }
        PhaseTimer timer = new PhaseTimer("get");
        int pNum = num.map(StringTool::nullIfEmpty).map(number -> number.replace(",", "")).map(Integer::valueOf).orElse(100000);
        int pMax = max.map(StringTool::nullIfEmpty).map(number -> number.replace(",", "")).map(Integer::valueOf).orElse(pNum);
        int pNumThreads = numThreads.map(StringTool::nullIfEmpty).map(number -> number.replace(",", "")).map(Integer::valueOf).orElse(10);
        int pBatchSize = batchSize.map(StringTool::nullIfEmpty).map(number -> number.replace(",", "")).map(Integer::valueOf).orElse(100);
        int pLogPeriod = logPeriod.map(StringTool::nullIfEmpty).map(number -> number.replace(",", "")).map(Integer::valueOf).orElse(10000);
        AtomicInteger rowCounter = new AtomicInteger(0);
        AtomicLong lastBatchFinished = new AtomicLong(System.nanoTime());
        int numBatches = LoadTestTool.numBatches(pNum, pBatchSize);
        ExecutorService executor = Executors.newFixedThreadPool(pNumThreads);
        Scanner.of(IntStream.range(0, numBatches).boxed()).map(batchId -> LoadTestTool.makeRandomIdBatch(pNum, pMax, pBatchSize, batchId)).map(ids -> new GetBatchCallable(this.dao.getReaderNode(), (List<Integer>)ids, pLogPeriod, rowCounter, lastBatchFinished)).parallelUnordered(new Threads(executor, pNumThreads)).forEach(CallableTool::callUnchecked);
        ExecutorServiceTool.shutdown((ExecutorService)executor, (Duration)Duration.ofSeconds(5L));
        timer.add("got " + rowCounter.get());
        DivTag message = (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Load Test Get Results"), TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Results"), TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Total Time"), TagCreator.dd((String)timer.getElapsedString()), TagCreator.dt((String)"Rows per second"), TagCreator.dd((String)("" + timer.getItemsPerSecond((long)rowCounter.get())))})}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Params"), TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Num"), TagCreator.dd((String)("" + pNum)), TagCreator.dt((String)"Max"), TagCreator.dd((String)("" + pMax)), TagCreator.dt((String)"Num Threads"), TagCreator.dd((String)("" + pNumThreads)), TagCreator.dt((String)"Batch Size"), TagCreator.dd((String)("" + pBatchSize)), TagCreator.dt((String)"Log Period"), TagCreator.dd((String)("" + pLogPeriod))})})}).withClass("container");
        logger.warn("total={}, rps={}, num={}, max={}, numThreads={} batchSize={}, logPeriod={}", new Object[]{timer.getElapsedString(), Float.valueOf(timer.getItemsPerSecond((long)rowCounter.get())), pNum, pMax, pNumThreads, pBatchSize, pLogPeriod});
        return this.pageFactory.message(this.request, (DomContent)message);
    }

    private static class GetBatchCallable
    implements Callable<Void> {
        private final MapStorageReader<RandomValueKey, RandomValue> node;
        private final List<Integer> ids;
        private final int logPeriod;
        private final AtomicInteger rowCounter;
        private final AtomicLong lastBatchFinished;

        public GetBatchCallable(MapStorageReader<RandomValueKey, RandomValue> node, List<Integer> ids, int logPeriod, AtomicInteger rowCounter, AtomicLong lastBatchFinished) {
            this.node = node;
            this.ids = ids;
            this.logPeriod = logPeriod;
            this.rowCounter = rowCounter;
            this.lastBatchFinished = lastBatchFinished;
        }

        @Override
        public Void call() {
            List databeans = (List)Scanner.of(this.ids).map(RandomValueKey::new).listTo(arg_0 -> this.node.getMulti(arg_0));
            databeans.forEach($ -> this.trackEachRow());
            return null;
        }

        private void trackEachRow() {
            int numCompleted = this.rowCounter.incrementAndGet();
            if (numCompleted % this.logPeriod == 0) {
                long duration = (System.nanoTime() - this.lastBatchFinished.get()) / 1000000L;
                double rps = (double)this.logPeriod / (double)duration * 1000.0;
                logger.warn("got {} @{}rps", (Object)NumberFormatter.addCommas((Number)numCompleted), (Object)NumberFormatter.addCommas((Number)rps));
                this.lastBatchFinished.set(System.nanoTime());
            }
        }
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(HtmlForm htmlForm) {
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Load Test - Get"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

