/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.storage;

import io.datarouter.loadtest.service.LoadTestGetDao;
import io.datarouter.loadtest.service.LoadTestInsertDao;
import io.datarouter.loadtest.service.LoadTestScanDao;
import io.datarouter.loadtest.storage.RandomValue;
import io.datarouter.loadtest.storage.RandomValueKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.storage.node.op.raw.write.StorageWriter;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterLoadTestDao
extends BaseDao
implements LoadTestGetDao,
LoadTestInsertDao,
LoadTestScanDao {
    private final Node<RandomValueKey, RandomValue, RandomValue.RandomValueFielder> node;

    @Inject
    public DatarouterLoadTestDao(Datarouter datarouter, NodeFactory nodeFactory, LoadTestDaoParams params) {
        super(datarouter);
        this.node = (Node)nodeFactory.create(params.clientId, RandomValue::new, RandomValue.RandomValueFielder::new).withTableName("LoadTest").buildAndRegister();
    }

    @Override
    public MapStorageReader<RandomValueKey, RandomValue> getReaderNode() {
        MapStorageReader readerNode = (MapStorageReader)this.node;
        return readerNode;
    }

    @Override
    public StorageWriter<RandomValueKey, RandomValue> getWriterNode() {
        StorageWriter writerNode = (StorageWriter)this.node;
        return writerNode;
    }

    @Override
    public Scanner<RandomValue> scan(int batchSize, int limit) {
        SortedMapStorage.SortedMapStorageNode scannerNode = (SortedMapStorage.SortedMapStorageNode)this.node;
        Config config = new Config().setOutputBatchSize(Integer.valueOf(batchSize)).setNoTimeout();
        return scannerNode.scan(config).limit((long)limit);
    }

    public static class LoadTestDaoParams
    extends BaseDaoParams {
        public LoadTestDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

