/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.Tracer;
import io.datarouter.instrumentation.trace.TracerThreadLocal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TracerTool {
    public static String getTraceId(Tracer tracer) {
        if (tracer == null) {
            return null;
        }
        return tracer.getTraceId();
    }

    public static String getCurrentTraceId() {
        return TracerTool.getTraceId(TracerThreadLocal.get());
    }

    public static void createAndStartThread(Tracer tracer, String name, long queueTimeMs) {
        if (tracer == null) {
            return;
        }
        tracer.createAndStartThread(name, queueTimeMs);
    }

    public static void createThread(Tracer tracer, String name, long queueTimeMs) {
        if (tracer == null) {
            return;
        }
        tracer.createThread(name, queueTimeMs);
    }

    public static void appendToThreadInfo(Tracer tracer, String text) {
        if (tracer == null) {
            return;
        }
        tracer.appendToThreadInfo(text);
    }

    public static void finishThread(Tracer tracer) {
        if (tracer == null) {
            return;
        }
        tracer.finishThread();
    }

    public static TraceSpanFinisher startSpan(Tracer tracer, String name) {
        if (tracer == null) {
            return new TraceSpanFinisher(tracer);
        }
        tracer.startSpan(name);
        return new TraceSpanFinisher(tracer);
    }

    public static TraceSpanFinisher startSpan(String name) {
        return TracerTool.startSpan(TracerThreadLocal.get(), name);
    }

    public static void appendToSpanInfo(String text) {
        TracerTool.appendToSpanInfo(TracerThreadLocal.get(), text);
    }

    public static void appendToSpanInfo(String key, Object value) {
        TracerTool.appendToSpanInfo(new TraceSpanInfoBuilder().add(key, value));
    }

    public static void appendToSpanInfo(TraceSpanInfoBuilder spanInfoBuilder) {
        String text = spanInfoBuilder.joinEntries();
        if (text.isBlank()) {
            return;
        }
        TracerTool.appendToSpanInfo(text);
    }

    public static void appendToSpanInfo(Tracer tracer, String text) {
        if (tracer == null) {
            return;
        }
        tracer.appendToSpanInfo(text);
    }

    public static void finishSpan(Tracer tracer) {
        if (tracer == null) {
            return;
        }
        tracer.finishSpan();
    }

    public static void finishSpan() {
        TracerTool.finishSpan(TracerThreadLocal.get());
    }

    public static void setForceSave() {
        Tracer tracer = TracerThreadLocal.get();
        if (tracer != null) {
            tracer.setForceSave();
        }
    }

    public static class TraceSpanInfoBuilder {
        private List<String> spanEntries = new ArrayList<String>();

        public TraceSpanInfoBuilder add(String key, Object value) {
            this.spanEntries.add(String.valueOf(key) + '=' + Objects.toString(value));
            return this;
        }

        public TraceSpanInfoBuilder databeans(Number count) {
            return this.add("databeans", count);
        }

        public TraceSpanInfoBuilder keys(Number count) {
            return this.add("keys", count);
        }

        public TraceSpanInfoBuilder ranges(Number count) {
            return this.add("ranges", count);
        }

        public TraceSpanInfoBuilder bytes(Number count) {
            return this.add("bytes", count);
        }

        public TraceSpanInfoBuilder rows(Number count) {
            return this.add("rows", count);
        }

        public String joinEntries() {
            return String.join((CharSequence)", ", this.spanEntries);
        }
    }
}

