/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import io.datarouter.instrumentation.trace.TraceSpanDto;
import io.datarouter.instrumentation.trace.TraceThreadDto;
import java.util.concurrent.BlockingQueue;

public interface Tracer {
    public String getServerName();

    public String getTraceId();

    public BlockingQueue<TraceThreadDto> getThreadQueue();

    public BlockingQueue<TraceSpanDto> getSpanQueue();

    public Long getCurrentThreadId();

    public Integer getDiscardedThreadCount();

    public void incrementDiscardedThreadCount(int var1);

    default public void createAndStartThread(String name, long queueTimeMs) {
        this.createThread(name, queueTimeMs);
        this.startThread();
    }

    public void createThread(String var1, long var2);

    public void startThread();

    public void addThread(TraceThreadDto var1);

    public void appendToThreadInfo(String var1);

    public void finishThread();

    public Integer getDiscardedSpanCount();

    public void startSpan(String var1);

    public void addSpan(TraceSpanDto var1);

    public void appendToSpanInfo(String var1);

    public void finishSpan();

    public void incrementDiscardedSpanCount(int var1);

    public boolean getForceSave();

    public void setForceSave();

    public Tracer createChildTracer();
}

