/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

public class TraceThreadDto {
    private String traceId;
    private Long threadId;
    private Long parentId;
    private String name;
    private String info;
    private String serverId;
    private Long created;
    private Long queuedDuration;
    private Long runningDuration;
    private Integer discardedSpanCount;
    private String hostThreadName;

    public TraceThreadDto(String traceId, Long threadId, Long parentId, String serverId, String name, Long created, String hostThreadName) {
        this.traceId = traceId;
        this.threadId = threadId;
        this.parentId = parentId;
        this.serverId = serverId;
        this.name = name;
        this.created = created;
        this.hostThreadName = hostThreadName;
    }

    public TraceThreadDto(String traceId, Long threadId, Long parentId, String name, String info, String serverId, Long created, Long queuedDuration, Long runningDuration, Integer discardedSpanCount, String hostThreadName) {
        this(traceId, threadId, parentId, serverId, name, created, hostThreadName);
        this.info = info;
        this.queuedDuration = queuedDuration;
        this.runningDuration = runningDuration;
        this.discardedSpanCount = discardedSpanCount;
    }

    public void markStart() {
        this.queuedDuration = System.currentTimeMillis() - this.created;
    }

    public void markFinish() {
        this.runningDuration = System.currentTimeMillis() - this.queuedDuration - this.created;
    }

    public Long getTotalDuration() {
        long queued = this.queuedDuration == null ? 0L : this.queuedDuration;
        long running = this.runningDuration == null ? 0L : this.runningDuration;
        return queued + running;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getQueuedDuration() {
        return this.queuedDuration;
    }

    public void setQueuedDuration(Long queuedDuration) {
        this.queuedDuration = queuedDuration;
    }

    public Long getRunningDuration() {
        return this.runningDuration;
    }

    public void setRunningDuration(Long runningDuration) {
        this.runningDuration = runningDuration;
    }

    public Integer getDiscardedSpanCount() {
        return this.discardedSpanCount;
    }

    public void setDiscardedSpanCount(Integer discardedSpanCount) {
        this.discardedSpanCount = discardedSpanCount;
    }

    public String getHostThreadName() {
        return this.hostThreadName;
    }
}

