/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import java.util.Optional;

public class TraceSpanDto {
    private String traceId;
    private Long threadId;
    private Integer sequence;
    private Integer parentSequence;
    private String name;
    private String info;
    private Long created;
    private Long duration;

    public TraceSpanDto(String traceId, Long threadId, Integer sequence, Integer parentSequence, Long created) {
        this.traceId = traceId;
        this.threadId = threadId;
        this.sequence = sequence;
        this.parentSequence = parentSequence;
        this.created = created;
    }

    public TraceSpanDto(String traceId, Long threadId, Integer sequence, Integer parentSequence, String name, String info, Long created, Long duration) {
        this(traceId, threadId, sequence, parentSequence, created);
        this.name = name;
        this.info = info;
        this.duration = duration;
    }

    public void markFinish() {
        this.duration = System.currentTimeMillis() - this.created;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getParentSequence() {
        return this.parentSequence;
    }

    public Integer getParentSequenceOrMinusOne() {
        return Optional.ofNullable(this.parentSequence).orElse(-1);
    }

    public void setParentSequence(Integer parentSequence) {
        this.parentSequence = parentSequence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }
}

