/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.inject;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.util.StreamTool;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InstanceRegistry {
    @Inject
    private DatarouterInjector datarouterInjector;
    private final Set<Object> set = Collections.newSetFromMap(new ConcurrentHashMap());

    public void register(Object obj) {
        this.set.add(obj);
    }

    private <T> Collection<T> getRegisteredInstancesOfType(Class<T> type) {
        return this.set.stream().flatMap(StreamTool.instancesOf(type)).collect(Collectors.toList());
    }

    public <T> Collection<T> getAllInstancesOfType(Class<T> type) {
        Map<String, T> boundInstances = this.datarouterInjector.getInstancesOfType(type);
        Collection<T> manualInstances = this.getRegisteredInstancesOfType(type);
        manualInstances.addAll(boundInstances.values());
        return manualInstances;
    }
}

