/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.compaction;

import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.client.hbase.compaction.HBaseCompactionInfo;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.util.HashMethods;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class DrhCompactionScheduler<PK extends PrimaryKey<PK>> {
    private static final long COMPACTION_EPOCH = LocalDate.parse("2011-03-01").atStartOfDay(ZoneId.of("US/Eastern")).toInstant().toEpochMilli();
    private Long windowStartMs;
    private Long windowEndMs;
    private DrRegionInfo<PK> regionInfo;
    private Long nextCompactTimeMs;

    public DrhCompactionScheduler(HBaseCompactionInfo compactionInfo, DrRegionInfo<PK> regionInfo) {
        long now = System.currentTimeMillis();
        this.windowStartMs = now - now % compactionInfo.getCompactionTriggerPeriod().toMillis();
        this.windowEndMs = this.windowStartMs + compactionInfo.getCompactionTriggerPeriod().toMillis();
        this.regionInfo = Objects.requireNonNull(regionInfo);
        this.computeAndSetNextCompactTime(compactionInfo);
    }

    public boolean shouldCompact() {
        return this.nextCompactTimeMs >= this.windowStartMs && this.nextCompactTimeMs < this.windowEndMs;
    }

    private void computeAndSetNextCompactTime(HBaseCompactionInfo compactionInfo) {
        long regionCompactionPeriodMs = compactionInfo.getCompactionPeriod(this.regionInfo).toMillis();
        long periodStartSeekerMs = COMPACTION_EPOCH + regionCompactionPeriodMs * ((this.windowStartMs - COMPACTION_EPOCH) / regionCompactionPeriodMs);
        String startKeyString = this.regionInfo.getRegion().getEncodedName();
        long regionHash = Math.abs(HashMethods.longDjbHash((String)startKeyString));
        Double offsetIntoCompactionPeriodPct = 1.0 * (double)regionHash / 9.223372036854776E18;
        Long offsetIntoCompactionPeriodMs = (long)(offsetIntoCompactionPeriodPct * (double)regionCompactionPeriodMs);
        this.nextCompactTimeMs = periodStartSeekerMs + offsetIntoCompactionPeriodMs;
        if (this.nextCompactTimeMs < this.windowStartMs) {
            this.nextCompactTimeMs = this.nextCompactTimeMs + regionCompactionPeriodMs;
        }
        this.nextCompactTimeMs = this.nextCompactTimeMs - this.nextCompactTimeMs % compactionInfo.getCompactionTriggerPeriod().toMillis();
    }

    public String getNextCompactTimeFormatted() {
        ZonedDateTime date = Instant.ofEpochMilli(this.nextCompactTimeMs).atZone(ZoneId.systemDefault());
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm, EEE").format(date);
    }
}

