/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.cluster;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.balancer.HBaseBalancerFactory;
import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.client.hbase.cluster.DrRegionListFactory;
import io.datarouter.client.hbase.cluster.DrServerList;
import io.datarouter.httpclient.response.Conditional;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.hbase.client.Admin;

public class HBaseTableManager<PK extends PrimaryKey<PK>> {
    private final Class<PK> pkClass;
    private final Supplier<List<DrRegionInfo<?>>> regionSupplier;

    public HBaseTableManager(Class<PK> pkClass, Supplier<List<DrRegionInfo<?>>> regionSupplier) {
        this.pkClass = pkClass;
        this.regionSupplier = regionSupplier;
    }

    public Scanner<PK> scanPartitionEndKeys() {
        return Scanner.of((Iterable)this.regionSupplier.get()).include(region -> region.getPartition() == 0).map(DrRegionInfo::getEndKeyTyped).map(Conditional::orElseThrow).map(Optional::orElseThrow).map(this.pkClass::cast);
    }

    @Singleton
    public static class HBaseTableManagerFactory {
        @Inject
        private HBaseClientManager hbaseClientManager;
        @Inject
        private DrRegionListFactory hbaseRegionListFactory;
        @Inject
        private HBaseBalancerFactory hbaseBalancerFactory;

        public <PK extends PrimaryKey<PK>> HBaseTableManager<PK> make(Node<PK, ?, ?> node) {
            PhysicalNode physicalNode = NodeTool.extractSinglePhysicalNode(node);
            ClientId clientId = physicalNode.getClientId();
            String tableName = physicalNode.getFieldInfo().getTableName();
            Admin admin = this.hbaseClientManager.getAdmin(clientId);
            DrServerList servers = new DrServerList(admin);
            Supplier<List<DrRegionInfo<?>>> regionSupplier = () -> this.hbaseRegionListFactory.make(clientId, servers, tableName, physicalNode, this.hbaseBalancerFactory.getBalancerForTable(clientId, tableName)).getRegions();
            return new HBaseTableManager(physicalNode.getFieldInfo().getPrimaryKeyClass(), regionSupplier);
        }
    }
}

