/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.subentity;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.config.DatarouterHBaseExecutors;
import io.datarouter.client.hbase.node.nonentity.HBaseNonEntityQueryBuilder;
import io.datarouter.client.hbase.node.nonentity.HBaseNonEntityResultParser;
import io.datarouter.client.hbase.node.subentity.HBaseSubEntityPageScanner;
import io.datarouter.client.hbase.node.subentity.HBaseSubEntityQueryBuilder;
import io.datarouter.client.hbase.node.subentity.HBaseSubEntityResultParser;
import io.datarouter.client.hbase.node.subentity.HBaseSubEntityResultParserFactory;
import io.datarouter.client.hbase.util.HBaseResultComparator;
import io.datarouter.client.hbase.util.HBaseTableTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientTableNodeNames;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.ScannerConfigTool;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.entity.SubEntitySortedMapStorageReaderNode;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.storage.util.KeyRangeTool;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Range;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSubEntityReaderNode<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements SubEntitySortedMapStorageReaderNode<EK, PK, D, F> {
    private static final Logger logger = LoggerFactory.getLogger(HBaseSubEntityReaderNode.class);
    private static final Set<String> TABLE_NAMES = new HashSet<String>();
    private final ClientTableNodeNames clientTableNodeNames;
    private final HBaseClientManager hBaseClientManager;
    private final EntityFieldInfo<EK, E> entityFieldInfo;
    private final EntityPartitioner<EK> partitioner;
    private final HBaseSubEntityResultParser<EK, PK, D> resultParser;
    private final HBaseNonEntityResultParser<EK, PK, D, F> nonEntityResultParser;
    private final ClientType<?, ?> clientType;
    private final DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor;
    protected final HBaseSubEntityQueryBuilder<EK, E, PK, D, F> queryBuilder;
    protected final HBaseNonEntityQueryBuilder<EK, PK, D> nonEntityQueryBuilder;
    private final HBaseResultComparator resultComparator;

    public HBaseSubEntityReaderNode(HBaseClientManager hBaseClientManager, EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params, ClientType<?, ?> clientType, DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor) {
        super(params, clientType);
        Require.isTrue((boolean)StringTool.notEmpty((String)this.getFieldInfo().getEntityNodePrefix()), (String)("missing entityNodePrefix for " + (Object)((Object)this)));
        this.hBaseClientManager = hBaseClientManager;
        this.clientType = clientType;
        this.datarouterHbaseClientExecutor = datarouterHbaseClientExecutor;
        this.clientTableNodeNames = new ClientTableNodeNames(this.getFieldInfo().getClientId(), this.getFieldInfo().getTableName(), this.getName());
        this.entityFieldInfo = new EntityFieldInfo(entityNodeParams);
        this.partitioner = this.entityFieldInfo.getEntityPartitioner();
        this.queryBuilder = new HBaseSubEntityQueryBuilder(this.entityFieldInfo, this.getFieldInfo());
        this.nonEntityQueryBuilder = new HBaseNonEntityQueryBuilder(this.partitioner);
        this.resultParser = HBaseSubEntityResultParserFactory.create(this.entityFieldInfo, this.getFieldInfo());
        this.nonEntityResultParser = new HBaseNonEntityResultParser(this.partitioner, this.getFieldInfo());
        this.resultComparator = new HBaseResultComparator(this.partitioner.getNumPrefixBytes());
        this.logWideRows();
    }

    private void logWideRows() {
        String tableName = this.getFieldInfo().getTableName();
        if (!this.getFieldInfo().isSingleDatabeanEntity() && TABLE_NAMES.add(tableName)) {
            logger.warn("potentially large rows in {}", (Object)tableName);
        }
    }

    public String getEntityNodePrefix() {
        return this.getFieldInfo().getEntityNodePrefix();
    }

    public boolean exists(PK key, Config config) {
        return this.get(key, config) != null;
    }

    public D get(PK key, Config config) {
        if (key == null) {
            return null;
        }
        return (D)((Databean)this.getMulti(List.of(key), config).stream().findFirst().orElse(null));
    }

    public List<D> getMulti(Collection<PK> pks, Config config) {
        Result[] hbaseResults;
        if (pks == null || pks.isEmpty()) {
            return List.of();
        }
        String clientName = this.getClientId().getName();
        String nodeName = this.getName();
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"getMulti requested", (String)clientName, (String)nodeName, (long)pks.size());
        List<Get> gets = this.queryBuilder.getGets(pks, false);
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Table table = this.getTable();){
                hbaseResults = HBaseTableTool.getUnchecked(table, gets);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<D> databeans = this.resultParser.getDatabeansWithMatchingQualifierPrefixMulti(hbaseResults);
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"getMulti found", (String)clientName, (String)nodeName, (long)databeans.size());
        return databeans;
    }

    public List<PK> getKeys(Collection<PK> pks, Config config) {
        Result[] hbaseResults;
        if (pks == null || pks.isEmpty()) {
            return List.of();
        }
        String clientName = this.getClientId().getName();
        String nodeName = this.getName();
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"getKeys requested", (String)clientName, (String)nodeName, (long)pks.size());
        List<Get> gets = this.queryBuilder.getGets(pks, true);
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Table table = this.getTable();){
                hbaseResults = HBaseTableTool.getUnchecked(table, gets);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<PK> result = this.resultParser.getPrimaryKeysWithMatchingQualifierPrefixMulti(hbaseResults);
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"getKeys found", (String)clientName, (String)nodeName, (long)result.size());
        return result;
    }

    public Scanner<PK> scanKeys(Range<PK> range, Config config) {
        Config subscanConfig = config.clone().setOffset(Integer.valueOf(0));
        Scanner scanner = this.makePageScanner(range, subscanConfig, true).map(this.resultParser::getPrimaryKeysWithMatchingQualifierPrefix).concat(Scanner::of).deduplicate().include(pk -> KeyRangeTool.contains((Range)range, (PrimaryKey)pk));
        return ScannerConfigTool.applyOffsetAndLimit((Scanner)scanner, (Config)config);
    }

    public Scanner<PK> scanRangesKeys(Collection<Range<PK>> ranges, Config config) {
        Config subscanConfig = config.clone().setOffset(Integer.valueOf(0));
        Scanner scanner = Scanner.of(ranges).collate(range -> this.scanKeys((Range<PK>)range, subscanConfig));
        return ScannerConfigTool.applyOffsetAndLimit((Scanner)scanner, (Config)config);
    }

    public Scanner<D> scan(Range<PK> range, Config config) {
        Config subscanConfig = config.clone().setOffset(Integer.valueOf(0));
        Scanner scanner = this.makePageScanner(range, subscanConfig, false).map(result -> this.resultParser.getDatabeansWithMatchingQualifierPrefix((Result)result, null)).concat(Scanner::of).include(databean -> KeyRangeTool.contains((Range)range, (PrimaryKey)((EntityPrimaryKey)databean.getKey())));
        return ScannerConfigTool.applyOffsetAndLimit((Scanner)scanner, (Config)config);
    }

    public Scanner<D> scanRanges(Collection<Range<PK>> ranges, Config config) {
        Config subscanConfig = config.clone().setOffset(Integer.valueOf(0));
        Scanner scanner = Scanner.of(ranges).collate(range -> this.scan((Range<PK>)range, subscanConfig));
        return ScannerConfigTool.applyOffsetAndLimit((Scanner)scanner, (Config)config);
    }

    public Scanner<Result> makePageScanner(Range<PK> range, Config config, boolean keysOnly) {
        HBaseSubEntityPageScanner<EK, PK, D, F> pageScanner = new HBaseSubEntityPageScanner<EK, PK, D, F>(this.clientType, this.clientTableNodeNames.getClientId(), this.clientTableNodeNames.getTableName(), this.clientTableNodeNames.getNodeName(), this.hBaseClientManager, this.datarouterHbaseClientExecutor, this.getFieldInfo(), this.partitioner, this.nonEntityQueryBuilder, this.resultComparator, this.nonEntityResultParser);
        return pageScanner.scanResults(range, config, keysOnly);
    }

    public HBaseSubEntityResultParser<EK, PK, D> getResultParser() {
        return this.resultParser;
    }

    public ClientTableNodeNames getClientTableNodeNames() {
        return this.clientTableNodeNames;
    }

    public EntityFieldInfo<EK, E> getEntityFieldInfo() {
        return this.entityFieldInfo;
    }

    protected Table getTable() {
        return this.hBaseClientManager.getTable(this.getClientId(), this.clientTableNodeNames.getTableName());
    }
}

