/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.balancer.imp;

import io.datarouter.client.hbase.balancer.BaseHBaseRegionBalancer;
import io.datarouter.client.hbase.balancer.HBaseBalanceLeveler;
import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.client.hbase.cluster.DrServerInfo;
import io.datarouter.client.hbase.cluster.DrServerList;
import io.datarouter.util.HashMethods;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ServerName;

public class ConsistentHashBalancer
extends BaseHBaseRegionBalancer {
    public static final Integer BUCKETS_PER_NODE = 1000;

    public ConsistentHashBalancer(String tableName) {
        super(tableName);
    }

    @Override
    public Map<DrRegionInfo<?>, ServerName> call() {
        SortedMap<Long, ServerName> consistentHashRing = ConsistentHashBalancer.buildServerHashRing(this.drhServerList, BUCKETS_PER_NODE);
        for (DrRegionInfo<?> drhRegionInfo : this.drhRegionList.getRegions()) {
            byte[] consistentHashInput = drhRegionInfo.getRegion().getEncodedNameAsBytes();
            ServerName serverName = ConsistentHashBalancer.calcServerNameForItem(consistentHashRing, consistentHashInput);
            this.serverByRegion.put(drhRegionInfo, serverName);
        }
        this.assertRegionCountsConsistent();
        HBaseBalanceLeveler leveler = new HBaseBalanceLeveler(this.drhServerList.getServerNames(), this.serverByRegion, this.tableName);
        this.serverByRegion = leveler.getBalancedDestinationByItem();
        this.assertRegionCountsConsistent();
        return this.serverByRegion;
    }

    public static SortedMap<Long, ServerName> buildServerHashRing(DrServerList servers, int numBucketsPerNode) {
        TreeMap<Long, ServerName> consistentHashRing = new TreeMap<Long, ServerName>();
        for (DrServerInfo server : servers.getServers()) {
            int i = 0;
            while (i < numBucketsPerNode) {
                long bucketPosition = HashMethods.longMd5DjbHash((String)(String.valueOf(server.getServerName().getHostAndPort()) + i));
                consistentHashRing.put(bucketPosition, server.getServerName());
                ++i;
            }
        }
        return consistentHashRing;
    }

    public static ServerName calcServerNameForItem(SortedMap<Long, ServerName> consistentHashRing, byte[] consistentHashInput) {
        long hash = HashMethods.longMd5DjbHash((byte[])consistentHashInput);
        if (!consistentHashRing.containsKey(hash)) {
            SortedMap<Long, ServerName> tail = consistentHashRing.tailMap(hash);
            hash = tail.isEmpty() ? consistentHashRing.firstKey() : tail.firstKey();
        }
        ServerName serverName = (ServerName)consistentHashRing.get(hash);
        return serverName;
    }
}

