/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.balancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseRegionMovement {
    private final String tableName;
    private final String regionName;
    private final ServerName currentServer;
    private final ServerName destinationServer;

    public HBaseRegionMovement(String tableName, String regionName, ServerName currentServer, ServerName destinationServer) {
        this.tableName = tableName;
        this.regionName = regionName;
        this.currentServer = currentServer;
        this.destinationServer = destinationServer;
    }

    public static Map<ServerName, List<HBaseRegionMovement>> getByCurrentServer(Collection<HBaseRegionMovement> movements) {
        TreeMap<ServerName, List<HBaseRegionMovement>> movementsByCurrentServer = new TreeMap<ServerName, List<HBaseRegionMovement>>();
        for (HBaseRegionMovement movement : movements) {
            movementsByCurrentServer.putIfAbsent(movement.currentServer, new ArrayList());
            ((List)movementsByCurrentServer.get(movement.currentServer)).add(movement);
        }
        return movementsByCurrentServer;
    }

    public byte[] getRegionNameBytes() {
        return Bytes.toBytes((String)this.regionName);
    }

    public byte[] getDestinationServerNameBytes() {
        return Bytes.toBytes((String)this.destinationServer.getServerName());
    }

    public String toString() {
        return String.format("HBaseRegionMovement [tableName=%s, regionName=%s, currentServer=%s, destinationServer=%s]", this.tableName, this.regionName, this.currentServer, this.destinationServer);
    }
}

