/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.subentity;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.config.DatarouterHBaseExecutors;
import io.datarouter.client.hbase.node.nonentity.HBaseNonEntityQueryBuilder;
import io.datarouter.client.hbase.node.nonentity.HBaseNonEntityResultParser;
import io.datarouter.client.hbase.util.HBaseResultComparator;
import io.datarouter.client.hbase.util.HBaseResultScannerTool;
import io.datarouter.client.hbase.util.HBaseScanBuilder;
import io.datarouter.client.hbase.util.HBaseTableTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.PagingScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.util.Require;
import io.datarouter.util.bytes.ByteRange;
import io.datarouter.util.tuple.Range;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;

public class HBaseSubEntityPageScanner<EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private static final int DEFAULT_SCAN_BATCH_SIZE = 100;
    private final ClientType<?, ?> clientType;
    private final ClientId clientId;
    private final String tableName;
    private final String nodeName;
    private final HBaseClientManager hBaseClientManager;
    private final DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor;
    private final EntityPartitioner<EK> partitioner;
    private final PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo;
    private final HBaseNonEntityQueryBuilder<EK, PK, D> queryBuilder;
    private final HBaseResultComparator resultComparator;
    private final HBaseNonEntityResultParser<EK, PK, D, F> resultParser;

    public HBaseSubEntityPageScanner(ClientType<?, ?> clientType, ClientId clientId, String tableName, String nodeName, HBaseClientManager hBaseClientManager, DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor, PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo, EntityPartitioner<EK> partitioner, HBaseNonEntityQueryBuilder<EK, PK, D> queryBuilder, HBaseResultComparator resultComparator, HBaseNonEntityResultParser<EK, PK, D, F> resultParser) {
        this.clientType = clientType;
        this.clientId = clientId;
        this.tableName = tableName;
        this.nodeName = nodeName;
        this.hBaseClientManager = hBaseClientManager;
        this.datarouterHbaseClientExecutor = datarouterHbaseClientExecutor;
        this.fieldInfo = fieldInfo;
        this.partitioner = partitioner;
        this.queryBuilder = queryBuilder;
        this.resultComparator = resultComparator;
        this.resultParser = resultParser;
    }

    public Scanner<Result> scanResults(Range<PK> range, Config config, boolean keysOnly) {
        Range byteRange = range.map(EntityPrimaryKey::getEntityKey).map(this.queryBuilder::getEkByteRange).setStartInclusive(true).setEndInclusive(true);
        int offset = config.optOffset().orElse(0);
        Integer subscanLimit = config.optLimit().map(limit -> offset + limit).orElse(null);
        int pageSize = config.optOutputBatchSize().orElse(100);
        boolean cacheBlocks = config.optScannerCaching().orElse(true);
        return this.partitioner.scanPrefixes(range).collate(prefix -> this.scanResultsInByteRange((byte[])prefix, (Range<ByteRange>)byteRange, pageSize, subscanLimit, cacheBlocks, keysOnly), (Comparator)this.resultComparator);
    }

    private Scanner<Result> scanResultsInByteRange(byte[] prefix, Range<ByteRange> range, int pageSize, Integer limit, boolean cacheBlocks, boolean keysOnly) {
        if (range.isEmpty()) {
            return Scanner.empty();
        }
        ResultPagingScanner pagingScanner = new ResultPagingScanner(pageSize, prefix, range, limit, cacheBlocks, keysOnly);
        return pagingScanner.concatenate(Scanner::of).prefetch((ExecutorService)((Object)this.datarouterHbaseClientExecutor), pageSize);
    }

    /*
     * Loose catch block
     */
    private List<Result> getPageOfResults(byte[] prefix, Range<ByteRange> rowRange, boolean keysOnly, int limit, boolean cacheBlocks) throws IOException {
        Scan scan = new HBaseScanBuilder().withPrefix(prefix).withRange(rowRange).withColumnPrefix(this.fieldInfo.getEntityNodePrefix()).withKeyOnly(keysOnly).withLimit(limit).withCacheBlocks(cacheBlocks).build();
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            List<Result> list;
            ResultScanner resultScanner;
            Table table;
            block16: {
                block15: {
                    table = this.hBaseClientManager.getTable(this.clientId, this.tableName);
                    resultScanner = HBaseTableTool.getResultScanner(table, scan);
                    List<Result> results = HBaseResultScannerTool.resultScannerNext(resultScanner, limit);
                    DatarouterCounters.incClientNodeCustom(this.clientType, (String)("scan " + (keysOnly ? "key" : "row") + " numRows"), (String)this.clientId.getName(), (String)this.nodeName, (long)results.size());
                    list = results;
                    if (resultScanner == null) break block15;
                    resultScanner.close();
                }
                if (table == null) break block16;
                table.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (resultScanner != null) {
                            resultScanner.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (table != null) {
                            table.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private class ResultPagingScanner
    extends PagingScanner<ByteRange, Result> {
        private final byte[] prefix;
        private final Range<ByteRange> mutableRange;
        private final boolean keysOnly;
        private final Optional<Integer> limit;
        private final boolean cacheBlocks;
        private long numFetched;
        private volatile boolean closed;

        public ResultPagingScanner(int pageSize, byte[] prefix, Range<ByteRange> range, Integer limit, boolean cacheBlocks, boolean keysOnly) {
            super(pageSize);
            this.prefix = prefix;
            this.mutableRange = range.clone();
            this.keysOnly = keysOnly;
            this.limit = Optional.ofNullable(limit);
            this.cacheBlocks = cacheBlocks;
            this.numFetched = 0L;
            this.closed = false;
        }

        protected ByteRange nextParam(Result lastSeenItem) {
            if (lastSeenItem == null) {
                return null;
            }
            byte[] rowWithoutPrefix = HBaseSubEntityPageScanner.this.resultParser.rowWithoutPrefix(lastSeenItem.getRow());
            return new ByteRange(rowWithoutPrefix);
        }

        protected List<Result> nextPage(ByteRange resumeFrom) {
            Require.isFalse((boolean)this.closed, (String)"don't call me, i'm closed");
            if (this.limit.isPresent() && this.numFetched >= (long)this.limit.get().intValue()) {
                return Collections.emptyList();
            }
            if (resumeFrom != null) {
                this.mutableRange.setStart((Comparable)resumeFrom);
                this.mutableRange.setStartInclusive(false);
            }
            int pageLimit = this.pageSize;
            if (this.limit.isPresent()) {
                long numRemaining = (long)this.limit.get().intValue() - this.numFetched;
                pageLimit = Math.min(this.pageSize, (int)numRemaining);
            }
            try {
                List<Result> page = HBaseSubEntityPageScanner.this.getPageOfResults(this.prefix, this.mutableRange, this.keysOnly, pageLimit, this.cacheBlocks);
                this.numFetched += (long)page.size();
                return page;
            }
            catch (IOException e) {
                if (this.closed) {
                    return Collections.emptyList();
                }
                throw new RuntimeException(e);
            }
        }

        public void close() {
            this.closed = true;
        }
    }
}

