/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.cluster;

import io.datarouter.client.hbase.cluster.DrServerInfo;
import io.datarouter.model.exception.DataAccessException;
import io.datarouter.util.collection.ListTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrServerList {
    private static final Logger logger = LoggerFactory.getLogger(DrServerList.class);
    private final List<DrServerInfo> servers;
    private final List<ServerName> serverNames;
    private final Map<ServerName, DrServerInfo> drhServerInfoByServerName;
    private final SortedSet<DrServerInfo> serversSortedByDescendingLoad;

    public DrServerList(Admin admin) {
        try {
            ClusterStatus clusterStatus = admin.getClusterStatus();
            this.serverNames = new ArrayList<ServerName>(clusterStatus.getServers());
            Collections.sort(this.serverNames);
            this.servers = ListTool.createArrayListWithSize(this.serverNames);
            this.serversSortedByDescendingLoad = new TreeSet<DrServerInfo>(DrServerInfo.COMPARATOR_DESC_SERVER_LOAD);
            this.drhServerInfoByServerName = new TreeMap<ServerName, DrServerInfo>();
            for (ServerName serverName : this.serverNames) {
                DrServerInfo info = new DrServerInfo(serverName, clusterStatus.getLoad(serverName));
                this.servers.add(info);
                this.serversSortedByDescendingLoad.add(info);
                this.drhServerInfoByServerName.put(serverName, info);
            }
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<ServerName> getServerNames() {
        return this.serverNames;
    }

    public List<ServerName> getServerNamesSorted() {
        return this.serverNames;
    }

    public SortedSet<String> getServerNameStrings() {
        TreeSet<String> serverNames = new TreeSet<String>();
        for (DrServerInfo server : this.servers) {
            serverNames.add(server.getName());
        }
        return serverNames;
    }

    public SortedSet<String> getServerHostnames() {
        TreeSet<String> serverNames = new TreeSet<String>();
        for (DrServerInfo server : this.servers) {
            serverNames.add(server.getHostname());
        }
        return serverNames;
    }

    public ServerLoad getHServerLoad(ServerName serverName) {
        DrServerInfo drhServerInfo = this.drhServerInfoByServerName.get(serverName);
        if (drhServerInfo == null) {
            logger.warn("unexpected DRHServerInfo null for " + serverName.getHostAndPort());
            return null;
        }
        return drhServerInfo.getServerLoad();
    }

    public int getNumServers() {
        return this.servers.size();
    }

    public List<DrServerInfo> getServers() {
        return this.servers;
    }

    public SortedSet<DrServerInfo> getServersSortedByDescendingLoad() {
        return this.serversSortedByDescendingLoad;
    }
}

