/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.balancer;

import io.datarouter.scanner.Scanner;
import io.datarouter.util.HashMethods;
import io.datarouter.util.collection.MapTool;
import io.datarouter.util.lang.ObjectTool;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ServerName;

public class HBaseBalanceLeveler<I> {
    public static final boolean PSEUDO_RANDOM_LEVELING = false;
    private final Collection<ServerName> allDestinations;
    private final SortedMap<I, ServerName> destinationByItem;
    private long minAtDestination;
    private long maxAtDestination;
    private SortedMap<ServerName, Long> countByDestination;

    public HBaseBalanceLeveler(Collection<ServerName> allDestinations, SortedMap<I, ServerName> unleveledDestinationByItem, String randomSeed) {
        this.allDestinations = allDestinations;
        this.destinationByItem = new TreeMap<I, ServerName>(unleveledDestinationByItem);
        this.countByDestination = new TreeMap<ServerName, Long>(new HostAndPortComparator());
        this.updateCountByDestination();
    }

    public SortedMap<I, ServerName> getBalancedDestinationByItem() {
        while (!this.isBalanced()) {
            ServerName mostLoadedDestination = this.getMostLoadedDestination();
            Object itemToMove = Scanner.of(this.destinationByItem.entrySet()).include(entry -> Objects.equals(entry.getValue(), mostLoadedDestination)).findFirst().map(Map.Entry::getKey).orElse(null);
            ServerName leastLoadedDestination = this.getLeastLoadedDestination();
            this.destinationByItem.put(itemToMove, leastLoadedDestination);
            this.updateCountByDestination();
        }
        return this.destinationByItem;
    }

    private void updateCountByDestination() {
        this.countByDestination.clear();
        this.destinationByItem.values().forEach(destination -> {
            Long l = MapTool.increment(this.countByDestination, (Object)destination);
        });
        if (this.countByDestination.size() > this.allDestinations.size()) {
            throw new IllegalStateException("countByDestination.size() is " + this.countByDestination.size() + " which is greater than " + this.allDestinations.size());
        }
        this.ensureAllDestinationsInCountByDestination();
        if (ObjectTool.notEquals((Object)this.countByDestination.size(), (Object)this.allDestinations.size())) {
            throw new IllegalStateException("countByDestination.size() is " + this.countByDestination.size() + " but should be " + this.allDestinations.size());
        }
        this.minAtDestination = this.countByDestination.values().stream().mapToLong(Long::longValue).min().orElse(0L);
        this.maxAtDestination = this.countByDestination.values().stream().mapToLong(Long::longValue).max().orElse(0L);
    }

    private void ensureAllDestinationsInCountByDestination() {
        this.allDestinations.forEach(destination -> {
            Long l = this.countByDestination.putIfAbsent((ServerName)destination, 0L);
        });
    }

    private boolean isBalanced() {
        return this.maxAtDestination - this.minAtDestination <= 1L;
    }

    private ServerName getMostLoadedDestination() {
        for (Map.Entry<ServerName, Long> entry : this.countByDestination.entrySet()) {
            if (!Objects.equals(entry.getValue(), this.maxAtDestination)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("max values out of sync");
    }

    private ServerName getLeastLoadedDestination() {
        for (Map.Entry<ServerName, Long> entry : this.countByDestination.entrySet()) {
            if (!Objects.equals(entry.getValue(), this.minAtDestination)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("min values out of sync");
    }

    private static class HostAndPortComparator
    implements Comparator<ServerName> {
        private HostAndPortComparator() {
        }

        @Override
        public int compare(ServerName serverA, ServerName serverB) {
            return serverA.getHostAndPort().compareTo(serverB.getHostAndPort());
        }
    }

    public static class TablePseudoRandomHostAndPortComparator
    implements Comparator<ServerName> {
        private final String randomSeed;

        public TablePseudoRandomHostAndPortComparator(String randomSeed) {
            this.randomSeed = randomSeed;
        }

        @Override
        public int compare(ServerName serverA, ServerName serverB) {
            long serverASort = HashMethods.longDjbHash((String)(String.valueOf(this.randomSeed) + serverA.getHostAndPort()));
            long serverBSort = HashMethods.longDjbHash((String)(String.valueOf(this.randomSeed) + serverB.getHostAndPort()));
            return (int)(serverASort - serverBSort);
        }
    }
}

