/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.subentity;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.util.HBaseEntityKeyTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.collection.CollectionTool;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.tuple.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseSubEntityResultParser<EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> {
    private final Supplier<EK> entityKeySupplier;
    private final Class<PK> primaryKeyClass;
    private final Supplier<D> databeanSupplier;
    private final int numPrefixBytes;
    private final byte[] entityColumnPrefixBytes;
    private final Map<String, io.datarouter.model.field.Field<?>> nonKeyFieldsByColumnNames;
    private final Field keyJavaField;
    private final List<io.datarouter.model.field.Field<?>> ekFields;
    private final List<io.datarouter.model.field.Field<?>> ekPkKeyFields;
    private final List<io.datarouter.model.field.Field<?>> postEkPkFields;

    protected HBaseSubEntityResultParser(Class<PK> primaryKeyClass, Supplier<EK> entityKeySupplier, List<io.datarouter.model.field.Field<?>> ekFields, List<io.datarouter.model.field.Field<?>> ekPkKeyFields, List<io.datarouter.model.field.Field<?>> postEkPkFields, Map<String, io.datarouter.model.field.Field<?>> nonKeyFieldsByColumnNames, int numPrefixBytes, byte[] entityColumnPrefixBytes, Field keyJavaField, Supplier<D> databeanSupplier) {
        this.primaryKeyClass = primaryKeyClass;
        this.databeanSupplier = databeanSupplier;
        this.entityKeySupplier = entityKeySupplier;
        this.ekPkKeyFields = ekPkKeyFields;
        this.numPrefixBytes = numPrefixBytes;
        this.entityColumnPrefixBytes = entityColumnPrefixBytes;
        this.ekFields = ekFields;
        this.postEkPkFields = postEkPkFields;
        this.keyJavaField = keyJavaField;
        this.nonKeyFieldsByColumnNames = nonKeyFieldsByColumnNames;
    }

    public EK getEkFromRowBytes(byte[] rowBytes) {
        return HBaseEntityKeyTool.getEkFromRowBytes(rowBytes, this.entityKeySupplier, this.numPrefixBytes, this.ekFields);
    }

    public Pair<PK, String> parsePrimaryKeyAndFieldName(Cell cell) {
        EntityPrimaryKey pk = (EntityPrimaryKey)ReflectionTool.create(this.primaryKeyClass);
        this.parseEkFieldsFromBytesToPk(cell, pk);
        int fieldNameOffset = this.parsePostEkFieldsFromBytesToPk(cell, pk);
        String fieldName = StringByteTool.fromUtf8BytesOffset((byte[])CellUtil.cloneQualifier((Cell)cell), (int)fieldNameOffset);
        return new Pair((Object)pk, (Object)fieldName);
    }

    public List<PK> getPrimaryKeysWithMatchingQualifierPrefixMulti(Result[] rows) {
        ArrayList results = new ArrayList();
        Result[] resultArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            Result row = resultArray[n2];
            if (!row.isEmpty()) {
                List<PK> pksFromSingleGet = this.getPrimaryKeysWithMatchingQualifierPrefix(row);
                results.addAll(CollectionTool.nullSafe(pksFromSingleGet));
            }
            ++n2;
        }
        return results;
    }

    public List<D> getDatabeansWithMatchingQualifierPrefixMulti(Result[] rows) {
        ArrayList results = new ArrayList();
        Result[] resultArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            Result row = resultArray[n2];
            if (!row.isEmpty()) {
                List<D> databeansFromSingleGet = this.getDatabeansWithMatchingQualifierPrefix(row, null);
                results.addAll(CollectionTool.nullSafe(databeansFromSingleGet));
            }
            ++n2;
        }
        return results;
    }

    public List<PK> getPrimaryKeysWithMatchingQualifierPrefix(Result row) {
        return this.getPrimaryKeysWithMatchingQualifierPrefix(row, null);
    }

    public List<PK> getPrimaryKeysWithMatchingQualifierPrefix(Result row, Integer limit) {
        if (row == null) {
            return Collections.emptyList();
        }
        return this.getPrimaryKeysWithMatchingQualifierPrefix(row.listCells(), limit);
    }

    public List<PK> getPrimaryKeysWithMatchingQualifierPrefix(List<Cell> cells, Integer limit) {
        if (CollectionTool.isEmpty(cells)) {
            return Collections.emptyList();
        }
        ArrayList<EntityPrimaryKey> pks = new ArrayList<EntityPrimaryKey>();
        EntityPrimaryKey previousPk = null;
        for (Cell cell : cells) {
            Pair<PK, String> pkAndFieldName;
            EntityPrimaryKey pk;
            if (!this.matchesNodePrefix(cell) || Objects.equals(previousPk, pk = (EntityPrimaryKey)(pkAndFieldName = this.parsePrimaryKeyAndFieldName(cell)).getLeft())) continue;
            pks.add(pk);
            if (limit != null && pks.size() >= limit) break;
            previousPk = pk;
        }
        return pks;
    }

    public List<D> getDatabeansWithMatchingQualifierPrefix(Result row, Integer limit) {
        if (row == null) {
            return Collections.emptyList();
        }
        return this.getDatabeansForKvsWithMatchingQualifierPrefix(row.listCells(), limit);
    }

    public List<D> getDatabeansForKvsWithMatchingQualifierPrefix(List<Cell> cells, Integer limit) {
        if (CollectionTool.isEmpty(cells)) {
            return Collections.emptyList();
        }
        ArrayList<Databean> databeans = new ArrayList<Databean>();
        Databean databean = null;
        for (Cell cell : cells) {
            Pair<PK, String> pkAndFieldName = this.parsePrimaryKeyAndFieldName(cell);
            if (databean == null || ObjectTool.notEquals((Object)databean.getKey(), (Object)pkAndFieldName.getLeft())) {
                if (limit != null && databeans.size() == limit.intValue()) break;
                databean = (Databean)this.databeanSupplier.get();
                ReflectionTool.set((Field)this.keyJavaField, (Object)databean, (Object)pkAndFieldName.getLeft());
                databeans.add(databean);
            }
            this.setDatabeanField(databean, (String)pkAndFieldName.getRight(), CellUtil.cloneValue((Cell)cell));
        }
        return databeans;
    }

    public void setDatabeanField(D databean, String fieldName, byte[] bytesValue) {
        if (HBaseClientManager.DUMMY_COL_NAME.equals(fieldName)) {
            return;
        }
        io.datarouter.model.field.Field<?> field = this.nonKeyFieldsByColumnNames.get(fieldName);
        if (field == null) {
            return;
        }
        Object value = field.fromBytesButDoNotSet(bytesValue, 0);
        field.setUsingReflection(databean, value);
    }

    private boolean matchesNodePrefix(Cell cell) {
        return cell.getQualifierLength() >= this.entityColumnPrefixBytes.length && Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)this.entityColumnPrefixBytes.length, (byte[])this.entityColumnPrefixBytes, (int)0, (int)this.entityColumnPrefixBytes.length);
    }

    private int parseEkFieldsFromBytesToPk(Cell cell, PK targetPk) {
        byte[] fromBytes = CellUtil.cloneRow((Cell)cell);
        return this.parseFieldsFromBytesToPk(this.ekPkKeyFields, fromBytes, this.numPrefixBytes, targetPk);
    }

    private int parsePostEkFieldsFromBytesToPk(Cell cell, PK targetPk) {
        int offset = this.entityColumnPrefixBytes.length;
        byte[] fromBytes = CellUtil.cloneQualifier((Cell)cell);
        try {
            return this.parseFieldsFromBytesToPk(this.postEkPkFields, fromBytes, offset, targetPk);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("failed to parse post ek field cellBytes=" + Bytes.toStringBinary((byte[])CellUtil.cloneRow((Cell)cell)), e);
        }
    }

    private int parseFieldsFromBytesToPk(List<io.datarouter.model.field.Field<?>> fields, byte[] fromBytes, int offset, PK targetPk) {
        int byteOffset = offset;
        for (io.datarouter.model.field.Field<?> field : fields) {
            Object value;
            try {
                value = field.fromBytesWithSeparatorButDoNotSet(fromBytes, byteOffset);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("failed to parse fromBytes=" + Bytes.toStringBinary((byte[])fromBytes) + " byteOffset=" + byteOffset + " fields=" + fields + " field=" + field, e);
            }
            field.setUsingReflection(targetPk, value);
            byteOffset += field.numBytesWithSeparator(fromBytes, byteOffset);
        }
        return byteOffset;
    }
}

