/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.test;

import io.datarouter.client.hbase.test.DatarouterEntityTestDao;
import io.datarouter.client.hbase.test.TestEntity;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.factory.EntityNodeFactory;
import io.datarouter.storage.node.factory.WideNodeFactory;
import io.datarouter.util.UlidTool;
import io.datarouter.util.number.RandomTool;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseTraceEntityIntegrationTests {
    private static final List<TestEntity.TestTrace> traces = new ArrayList<TestEntity.TestTrace>();
    private static final List<TestEntity.TestTraceThread> threads = new ArrayList<TestEntity.TestTraceThread>();
    private static final List<TestEntity.TestTraceSpan> spans = new ArrayList<TestEntity.TestTraceSpan>();
    private static final String id = UlidTool.nextUlid();
    private final DatarouterEntityTestDao dao;

    static {
        TestEntity.TestTrace trace1 = new TestEntity.TestTrace(id);
        traces.add(trace1);
        TestEntity.TestTraceThread thread1a = new TestEntity.TestTraceThread(trace1.getTraceId(), 0L);
        threads.add(thread1a);
        Assert.assertEquals((String)((TestEntity.TestTraceThreadKey)thread1a.getKey()).getId(), (String)trace1.getTraceId());
        TestEntity.TestTraceSpan span1a1 = new TestEntity.TestTraceSpan(((TestEntity.TestTraceThreadKey)thread1a.getKey()).getId(), thread1a.getThreadId(), 1, 1);
        spans.add(span1a1);
        TestEntity.TestTraceSpan span1a2 = new TestEntity.TestTraceSpan(((TestEntity.TestTraceThreadKey)thread1a.getKey()).getId(), thread1a.getThreadId(), 2, 1);
        spans.add(span1a2);
        TestEntity.TestTraceThread thread1b = new TestEntity.TestTraceThread(trace1.getTraceId(), RandomTool.nextPositiveLong());
        threads.add(thread1b);
        Assert.assertEquals((String)thread1b.getTraceId(), (String)trace1.getTraceId());
        TestEntity.TestTraceSpan span1b1 = new TestEntity.TestTraceSpan(thread1b.getTraceId(), thread1b.getThreadId(), 1, 1);
        spans.add(span1b1);
        TestEntity.TestTraceSpan span1b2 = new TestEntity.TestTraceSpan(thread1b.getTraceId(), thread1b.getThreadId(), 2, 1);
        spans.add(span1b2);
        TestEntity.TestTraceSpan span1b3 = new TestEntity.TestTraceSpan(thread1b.getTraceId(), thread1b.getThreadId(), 3, 1);
        spans.add(span1b3);
        Assert.assertEquals((String)span1b3.getTraceId(), (String)trace1.getTraceId());
        for (TestEntity.TestTrace trace : traces) {
            trace.setContext("blah");
            trace.setDuration(123L);
            trace.setParams("paramA=a&paramB=b");
            trace.setType("mighty");
        }
        for (TestEntity.TestTraceThread thread : threads) {
            thread.setInfo("the info");
            thread.setName("my name");
            thread.setParentId(2222L);
            thread.setQueuedDuration(111L);
            thread.setRunningDuration(33333L);
            thread.setServerId("el server");
        }
        for (TestEntity.TestTraceSpan span : spans) {
            span.setDuration(321L);
            span.setInfo("the info is lost");
            span.setName("phillip");
        }
    }

    public BaseTraceEntityIntegrationTests(Datarouter datarouter, EntityNodeFactory entityNodeFactory, WideNodeFactory wideNodeFactory, ClientId clientId) {
        this.dao = new DatarouterEntityTestDao(datarouter, entityNodeFactory, wideNodeFactory, clientId);
    }

    @Test
    public void testSimple() {
        String idSimple = UlidTool.nextUlid();
        TestEntity.TestTrace trace = new TestEntity.TestTrace(idSimple, System.currentTimeMillis());
        this.dao.put(trace);
        TestEntity.TestTrace roundTrippedTrace = this.dao.getEntity(new TestEntity.TestTraceEntityKey(idSimple)).getTrace();
        Assert.assertEquals((Object)((Object)roundTrippedTrace), (Object)((Object)trace));
    }

    @Test
    public void testRoundTripped() {
        this.dao.putMulti(traces, threads, spans);
        TestEntity.TestTraceEntityKey ek = new TestEntity.TestTraceEntityKey(id);
        TestEntity.TestTrace roundTrippedTrace = this.dao.getEntity(ek).getTrace();
        Assert.assertEquals((Object)((Object)roundTrippedTrace), (Object)((Object)traces.get(0)));
        ArrayList<TestEntity.TestTraceSpan> roundTrippedSpans = this.dao.getEntity(ek).getTraceSpans();
        Assert.assertEquals((int)roundTrippedSpans.size(), (int)spans.size());
        Assert.assertEquals(roundTrippedSpans, spans);
        ArrayList<TestEntity.TestTraceThread> roundTrippedThreads = this.dao.getEntity(ek).getTraceThreads();
        Assert.assertEquals((int)roundTrippedThreads.size(), (int)threads.size());
        Assert.assertEquals(roundTrippedThreads, threads);
    }
}

