/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.pool;

import io.datarouter.util.concurrent.ExecutorServiceTool;
import io.datarouter.util.concurrent.NamedThreadFactory;
import io.datarouter.util.concurrent.ThreadTool;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTableExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(HBaseTableExecutorService.class);
    private static final long TIMEOUT_MS = 10000L;
    private static final AtomicInteger executorServiceNumber = new AtomicInteger(1);
    private final ThreadPoolExecutor exec;
    private final long createdMs;
    private volatile long lastCheckInMs;

    public HBaseTableExecutorService(int minThreads, int maxThreads) {
        SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        NamedThreadFactory threadFactory = new NamedThreadFactory("htable-" + executorServiceNumber.incrementAndGet(), false);
        this.exec = new ThreadPoolExecutor(minThreads, maxThreads, 60L, TimeUnit.SECONDS, queue, (ThreadFactory)threadFactory);
        this.exec.allowCoreThreadTimeOut(true);
        this.lastCheckInMs = this.createdMs = System.currentTimeMillis();
    }

    public void markLastCheckinMs() {
        this.lastCheckInMs = System.currentTimeMillis();
    }

    public boolean isExpired() {
        long elapsedMs = System.currentTimeMillis() - this.lastCheckInMs;
        return elapsedMs > 10000L;
    }

    public void purge() {
        this.exec.purge();
    }

    public boolean isTaskQueueEmpty() {
        return this.exec.getQueue().size() == 0;
    }

    public boolean isDyingOrDead(String tableNameForLog) {
        if (this.exec.isShutdown()) {
            logger.warn("executor isShutdown, table:" + tableNameForLog);
            return true;
        }
        if (this.exec.isTerminated()) {
            logger.warn("executor isTerminated, table:" + tableNameForLog);
            return true;
        }
        if (this.exec.isTerminating()) {
            logger.warn("executor isTerminating, table:" + tableNameForLog);
            return true;
        }
        return false;
    }

    public boolean waitForActiveThreadsToSettle(String tableNameForLog) {
        if (this.exec.getActiveCount() == 0) {
            return true;
        }
        ThreadTool.sleep((long)1L);
        if (this.exec.getActiveCount() == 0) {
            return true;
        }
        ThreadTool.sleep((long)10L);
        if (this.exec.getActiveCount() == 0) {
            logger.warn("had to sleep a long time to let threads finish, table:" + tableNameForLog);
            return true;
        }
        logger.warn("still have active threads after 11ms, table:" + tableNameForLog);
        return false;
    }

    public void terminateAndBlockUntilFinished() {
        ExecutorServiceTool.shutdown((ExecutorService)this.exec, (Duration)Duration.ofDays(1L));
    }

    public ThreadPoolExecutor getExec() {
        return this.exec;
    }
}

