/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.entity;

import io.datarouter.client.hbase.node.subentity.HBaseSubEntityReaderNode;
import io.datarouter.client.hbase.node.subentity.HBaseSubEntityResultParser;
import io.datarouter.client.hbase.util.HBaseEntityKeyTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.field.Field;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.node.adapter.BaseAdapter;
import io.datarouter.storage.node.adapter.callsite.physical.PhysicalSubEntitySortedMapStorageCallsiteAdapter;
import io.datarouter.storage.node.entity.SubEntitySortedMapStorageReaderNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.collection.MapTool;
import io.datarouter.util.iterable.IterableTool;
import io.datarouter.util.lang.ObjectTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;

public class HBaseEntityResultParser<EK extends EntityKey<EK>, E extends Entity<EK>> {
    private final EntityFieldInfo<EK, E> entityFieldInfo;
    private final Map<String, ? extends SubEntitySortedMapStorageReaderNode<EK, ?, ?, ?>> nodeByQualifierPrefix;
    private final Supplier<EK> entityKeySupplier;
    private final int numPrefixBytes;
    private final List<Field<?>> ekFields;

    public HBaseEntityResultParser(EntityFieldInfo<EK, E> entityFieldInfo, Map<String, ? extends SubEntitySortedMapStorageReaderNode<EK, ?, ?, ?>> nodeByQualifierPrefix, Supplier<EK> entityKeySupplier, int numPrefixBytes, List<Field<?>> ekFields) {
        this.entityFieldInfo = entityFieldInfo;
        this.nodeByQualifierPrefix = nodeByQualifierPrefix;
        this.entityKeySupplier = entityKeySupplier;
        this.numPrefixBytes = numPrefixBytes;
        this.ekFields = ekFields;
    }

    public E parseEntity(Result row) {
        Entity entity = (Entity)this.entityFieldInfo.getEntitySupplier().get();
        entity.setKey(this.getEkFromRowBytes(row.getRow()));
        Map<String, List<Databean<?, ?>>> databeansByQualifierPrefix = this.getDatabeansByQualifierPrefix(row);
        for (String qualifierPrefix : MapTool.nullSafe(databeansByQualifierPrefix).keySet()) {
            SubEntitySortedMapStorageReaderNode<EK, ?, ?, ?> subNode = this.nodeByQualifierPrefix.get(qualifierPrefix);
            List<Databean<?, ?>> databeans = databeansByQualifierPrefix.get(qualifierPrefix);
            entity.addDatabeansForQualifierPrefixUnchecked(subNode.getEntityNodePrefix(), databeans);
        }
        return (E)entity;
    }

    public EK getEkFromRowBytes(byte[] rowBytes) {
        return HBaseEntityKeyTool.getEkFromRowBytes(rowBytes, this.entityKeySupplier, this.numPrefixBytes, this.ekFields);
    }

    private <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> Map<String, List<? extends Databean<?, ?>>> getDatabeansByQualifierPrefix(Result row) {
        if (row == null) {
            return Collections.emptyMap();
        }
        Map<String, List<Cell>> cellsByQp = this.getKvsByQualifierPrefix(row);
        HashMap databeansByQp = new HashMap();
        for (Map.Entry<String, List<Cell>> entry : cellsByQp.entrySet()) {
            HBaseSubEntityReaderNode hbaseNode;
            String qp = entry.getKey();
            SubEntitySortedMapStorageReaderNode subNode = this.nodeByQualifierPrefix.get(qp);
            if (subNode instanceof BaseAdapter) {
                subNode = (SubEntitySortedMapStorageReaderNode)((PhysicalSubEntitySortedMapStorageCallsiteAdapter)subNode).getUnderlyingNode();
            }
            if ((hbaseNode = (HBaseSubEntityReaderNode)subNode) == null) continue;
            HBaseSubEntityResultParser subParser = hbaseNode.getResultParser();
            List databeansForQp = subParser.getDatabeansForKvsWithMatchingQualifierPrefix(entry.getValue(), null);
            databeansByQp.put(qp, databeansForQp);
        }
        return databeansByQp;
    }

    private Map<String, List<Cell>> getKvsByQualifierPrefix(Result row) {
        HashMap<String, List<Cell>> cellsByQp = new HashMap<String, List<Cell>>();
        ArrayList<Cell> cellsForQp = new ArrayList<Cell>();
        String previousQp = null;
        for (Cell cell : IterableTool.nullSafe((Iterable)row.listCells())) {
            String qp = this.getQualifierPrefix(cell);
            if (ObjectTool.notEquals(previousQp, (Object)qp)) {
                cellsForQp = new ArrayList();
                cellsByQp.put(qp, cellsForQp);
                previousQp = qp;
            }
            cellsForQp.add(cell);
        }
        return cellsByQp;
    }

    private String getQualifierPrefix(Cell cell) {
        int backingArrayOffset = cell.getQualifierOffset();
        int qualifierPrefixLength = this.getQualifierPrefixLength(cell);
        return StringByteTool.fromUtf8Bytes((byte[])cell.getQualifierArray(), (int)backingArrayOffset, (int)qualifierPrefixLength);
    }

    private int getQualifierPrefixLength(Cell cell) {
        int qualifierOffset = cell.getQualifierOffset();
        int qualifierLength = cell.getQualifierLength();
        byte[] buffer = cell.getQualifierArray();
        int prefixLength = 0;
        while (prefixLength < qualifierLength) {
            if (buffer[qualifierOffset + prefixLength] == 0) {
                return prefixLength;
            }
            ++prefixLength;
        }
        throw new IllegalArgumentException("couldn't find entity prefix termination byte");
    }
}

