/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.config;

import io.datarouter.storage.setting.DatarouterSettingCategory;
import io.datarouter.storage.setting.SettingCategory;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.SettingRoot;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.util.DateTool;
import io.datarouter.util.number.NumberTool;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterHBaseSettingRoot
extends SettingRoot {
    public final Integer executorThreadCount = (Integer)this.registerInteger("executorThreadCount", 100).get();
    public final Integer executorQueueSize = (Integer)this.registerInteger("executorQueueSize", 1).get();
    public final CachedSetting<Boolean> runHbaseRegionBalancerJob = this.registerBoolean("runHbaseRegionBalancerJob", false);
    public final CachedSetting<Integer> regionBalancerRegionsPerMinute = this.registerInteger("regionBalancerRegionsPerMinute", 250);
    public final CachedSetting<Boolean> runHbaseCompactionJob = this.registerBoolean("runHbaseCompactionJob", false);
    public final CachedSetting<Boolean> enablePrefetching = this.registerBoolean("enablePrefetching", true);

    @Inject
    public DatarouterHBaseSettingRoot(SettingFinder finder) {
        super(finder, (SettingCategory)DatarouterSettingCategory.DATAROUTER, "datarouterHBase.");
    }

    public long getSleepBetweenRegionMovementMs() {
        long rpm = ((Integer)this.regionBalancerRegionsPerMinute.get()).intValue();
        long msBetweenRegions = (long)DateTool.MILLISECONDS_IN_MINUTE / rpm;
        return msBetweenRegions;
    }

    public boolean shouldRunHBaseRegionBalancerJob() {
        return (Boolean)this.runHbaseRegionBalancerJob.get() != false && NumberTool.isPositive((Integer)((Integer)this.regionBalancerRegionsPerMinute.get()));
    }
}

