/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.balancer;

import io.datarouter.client.hbase.HBaseClientType;
import io.datarouter.client.hbase.balancer.BaseHBaseRegionBalancer;
import io.datarouter.client.hbase.balancer.HBaseBalancerFactory;
import io.datarouter.client.hbase.balancer.imp.ConsistentHashBalancer;
import io.datarouter.client.hbase.balancer.imp.EntityPartitionBalancer;
import io.datarouter.client.hbase.balancer.imp.NoOpBalancer;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.DatarouterNodes;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultHBaseBalancerFactory
implements HBaseBalancerFactory {
    @Inject
    private DatarouterClients clients;
    @Inject
    private DatarouterNodes nodes;

    @Override
    public BaseHBaseRegionBalancer getBalancerForTable(ClientId clientId, String tableName) {
        if (!this.isHBase(clientId)) {
            return new NoOpBalancer(tableName);
        }
        if (this.nodes.getPhysicalNodeForClientAndTable(clientId.getName(), tableName).getFieldInfo().isSubEntity()) {
            return new EntityPartitionBalancer(tableName);
        }
        return new ConsistentHashBalancer(tableName);
    }

    private boolean isHBase(ClientId clientId) {
        return HBaseClientType.class == this.clients.getClientTypeInstance(clientId).getClass();
    }
}

