/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.HBaseClientNodeFactory;
import io.datarouter.client.hbase.config.DatarouterHBaseTestNgModuleFactory;
import io.datarouter.client.hbase.web.HBaseWebInspector;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.ClientTypeRegistry;
import io.datarouter.web.browse.DatarouterClientWebInspectorRegistry;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Singleton
public class HBaseClientType
implements ClientType<HBaseClientNodeFactory, HBaseClientManager> {
    public static final String NAME = "hbase";
    public static final String NAME_BIG_TABLE = "bigtable";

    @Inject
    public HBaseClientType(DatarouterClientWebInspectorRegistry datarouterClientWebInspectorRegistry) {
        datarouterClientWebInspectorRegistry.register(NAME, HBaseWebInspector.class);
    }

    public String getName() {
        return NAME;
    }

    public Class<HBaseClientNodeFactory> getClientNodeFactoryClass() {
        return HBaseClientNodeFactory.class;
    }

    public Class<HBaseClientManager> getClientManagerClass() {
        return HBaseClientManager.class;
    }

    public static boolean isBigTable(ClientType<?, ?> clientType) {
        return NAME_BIG_TABLE.equals(clientType.getName());
    }

    @Guice(moduleFactory=DatarouterHBaseTestNgModuleFactory.class)
    public static class HBaseClientTypeTests {
        @Inject
        private ClientTypeRegistry clientTypeRegistry;

        @Test
        public void testClassLocation() {
            Assert.assertEquals(HBaseClientType.class, this.clientTypeRegistry.get(HBaseClientType.NAME).getClass());
        }
    }
}

