/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.web;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.config.DatarouterHBaseFiles;
import io.datarouter.client.hbase.config.DatarouterHBasePaths;
import io.datarouter.httpclient.path.PathNode;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.util.collection.CollectionTool;
import io.datarouter.util.collection.ListTool;
import io.datarouter.util.iterable.IterableTool;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

@Singleton
public class HBaseWebInspector
implements DatarouterClientWebInspector {
    @Deprecated
    public static final String PATH_JSP_HBASE = "/jsp/admin/datarouter/hbase/";
    @Inject
    private DatarouterNodes datarouterNodes;
    @Inject
    private DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory;
    @Inject
    private DatarouterHBaseFiles files;
    @Inject
    private HBaseClientManager hBaseClientManager;
    @Inject
    private DatarouterHBasePaths datarouterHBasePaths;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        ArrayList tables;
        Mav mav = new Mav();
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.datarouterWebRequestParamsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams routerParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, ClientType.class);
        if (routerParams.getClientId() == null) {
            return new MessageMav("Client not found");
        }
        mav.setViewName(this.files.jsp.admin.datarouter.hbase.hbaseClientSummaryJsp);
        mav.put("address", (Object)this.hBaseClientManager.getConnection(routerParams.getClientId()).getConfiguration().get("hbase.zookeeper.quorum"));
        try {
            tables = ListTool.create((Object[])this.hBaseClientManager.getAdmin(routerParams.getClientId()).listTables());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TreeMap tableSummaryByName = new TreeMap();
        TreeMap<String, Map<String, Map<String, String>>> familySummaryByTableName = new TreeMap<String, Map<String, Map<String, String>>>();
        List<String> tableNamesForClient = this.getTableNames(routerParams);
        for (HTableDescriptor table : IterableTool.nullSafe((Iterable)tables)) {
            String tableName = table.getNameAsString();
            if (!CollectionTool.nullSafe(tableNamesForClient).contains(tableName)) continue;
            TreeMap<String, String> tableAttributeByName = new TreeMap<String, String>();
            tableAttributeByName.put("maxFileSize", String.valueOf(table.getMaxFileSize()));
            tableAttributeByName.put("memStoreFlushSize", String.valueOf(table.getMemStoreFlushSize()));
            tableAttributeByName.put("readOnly", String.valueOf(table.isReadOnly()));
            tableSummaryByName.put(tableName, tableAttributeByName);
            Map<String, Map<String, String>> familyAttributeByNameByFamilyName = HBaseWebInspector.parseTableAttributeMap(table.getFamilies());
            familySummaryByTableName.put(table.getNameAsString(), familyAttributeByNameByFamilyName);
        }
        mav.put("tableSummaryByName", tableSummaryByName);
        mav.put("familySummaryByTableName", familySummaryByTableName);
        mav.put("clientType", (Object)routerParams.getClientType().getName());
        mav.put("hbaseHandlerPath", (Object)this.getHandlerPath().toSlashedString());
        return mav;
    }

    protected PathNode getHandlerPath() {
        return this.datarouterHBasePaths.datarouter.clients.hbase;
    }

    private static Map<String, Map<String, String>> parseTableAttributeMap(Collection<HColumnDescriptor> families) {
        TreeMap<String, Map<String, String>> familyAttributeByNameByFamilyName = new TreeMap<String, Map<String, String>>();
        for (HColumnDescriptor family : IterableTool.nullSafe(families)) {
            TreeMap<String, String> familyAttributeByName = new TreeMap<String, String>();
            familyAttributeByNameByFamilyName.put(family.getNameAsString(), familyAttributeByName);
            for (Map.Entry e : family.getValues().entrySet()) {
                String key = Bytes.toString((byte[])((ImmutableBytesWritable)e.getKey()).get());
                String value = Bytes.toString((byte[])((ImmutableBytesWritable)e.getValue()).get());
                familyAttributeByName.put(key, value);
            }
        }
        return familyAttributeByNameByFamilyName;
    }

    private List<String> getTableNames(DatarouterWebRequestParamsFactory.DatarouterWebRequestParams<?> routerParams) {
        return this.datarouterNodes.getTableNamesForClient(routerParams.getClientId().getName());
    }
}

