/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.cluster;

import io.datarouter.client.hbase.compaction.DrhCompactionScheduler;
import io.datarouter.client.hbase.compaction.HBaseCompactionInfo;
import io.datarouter.client.hbase.node.nonentity.HBaseReaderNode;
import io.datarouter.client.hbase.node.subentity.HBaseSubEntityReaderNode;
import io.datarouter.model.field.FieldSet;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.lang.ClassTool;
import io.datarouter.util.number.NumberFormatter;
import java.util.Objects;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrRegionInfo<PK extends PrimaryKey<PK>>
implements Comparable<DrRegionInfo<?>> {
    private static final Logger logger = LoggerFactory.getLogger(DrRegionInfo.class);
    private final Integer regionNum;
    private final String tableName;
    private final String name;
    private final HRegionInfo regionInfo;
    private final ServerName serverName;
    private final PhysicalNode<?, ?, ?> node;
    private final DatabeanFieldInfo<?, ?, ?> fieldInfo;
    private final Integer partition;
    private final RegionLoad load;
    private final DrhCompactionScheduler<PK> compactionScheduler;
    private final HBaseCompactionInfo compactionInfo;
    private final EntityFieldInfo<?, ?> entityFieldInfo;
    private ServerName balancerDestinationServer;

    public DrRegionInfo(Integer regionNum, String tableName, HRegionInfo regionInfo, ServerName serverName, PhysicalNode<?, ?, ?> node, RegionLoad load, HBaseCompactionInfo compactionInfo, EntityFieldInfo<?, ?> entityFieldInfo) {
        this.regionNum = regionNum;
        this.tableName = tableName;
        this.compactionInfo = compactionInfo;
        this.name = new String(regionInfo.getRegionName());
        this.regionInfo = regionInfo;
        this.serverName = serverName;
        this.node = node;
        this.fieldInfo = node.getFieldInfo();
        this.load = load;
        this.compactionScheduler = new DrhCompactionScheduler(compactionInfo, this);
        this.entityFieldInfo = entityFieldInfo;
        this.partition = this.calculatePartition(regionInfo.getStartKey());
    }

    private FieldSet<?> getKey(byte[] bytes) {
        try {
            if (this.fieldInfo.isSubEntity()) {
                HBaseSubEntityReaderNode subEntityNode = (HBaseSubEntityReaderNode)this.node;
                return subEntityNode.getResultParser().getEkFromRowBytes(bytes);
            }
            HBaseReaderNode nonEntityNode = (HBaseReaderNode)this.node;
            return nonEntityNode.getResultParser().toPk(bytes);
        }
        catch (RuntimeException e) {
            logger.warn("error on {}, {}", new Object[]{this.node.getName(), Bytes.toStringBinary((byte[])bytes), e});
            return null;
        }
    }

    private Integer calculatePartition(byte[] bytes) {
        if (ArrayTool.isEmpty((byte[])bytes)) {
            return 0;
        }
        return this.entityFieldInfo.getEntityPartitioner().parsePartitionFromBytes(bytes);
    }

    public ServerName getConsistentHashServerName() {
        return this.balancerDestinationServer;
    }

    public boolean isNotOnAnyServer() {
        return this.serverName == null;
    }

    public boolean isOnCorrectServer() {
        try {
            return Objects.equals(this.serverName, this.balancerDestinationServer);
        }
        catch (NullPointerException npe) {
            logger.warn("", (Throwable)npe);
            return true;
        }
    }

    public ServerName getHBaseServerName() {
        return this.serverName;
    }

    public ServerName getBalancerDestinationHBaseServerName() {
        return this.balancerDestinationServer;
    }

    public String getServerName() {
        return this.serverName.getServerName();
    }

    public String getDisplayServerName() {
        return this.compactionInfo.getDisplayServerName(this.serverName.getHostname());
    }

    public String getConsistentHashDisplayServerName() {
        return this.compactionInfo.getDisplayServerName(this.balancerDestinationServer.getHostname());
    }

    public String getNumKeyValuesWithCompactionPercent() {
        if (this.load == null) {
            return "?";
        }
        long totalKvs = this.load.getTotalCompactingKVs();
        String totalKvsString = NumberFormatter.addCommas((Number)totalKvs);
        long compactingKvs = this.load.getCurrentCompactedKVs();
        if (totalKvs == compactingKvs) {
            return totalKvsString;
        }
        int percentCompacted = (int)(100.0 * (double)compactingKvs / (double)totalKvs);
        return String.valueOf(totalKvsString) + " [" + percentCompacted + "%]";
    }

    public Integer getRegionNum() {
        return this.regionNum;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getName() {
        return this.name;
    }

    public FieldSet<?> getStartKey() {
        byte[] startKey = this.regionInfo.getStartKey();
        return startKey.length == 0 ? null : this.getKey(startKey);
    }

    public FieldSet<?> getEndKey() {
        byte[] endKey = this.regionInfo.getEndKey();
        return endKey.length == 0 ? null : this.getKey(endKey);
    }

    public Integer getPartition() {
        return this.partition;
    }

    public HRegionInfo getRegion() {
        return this.regionInfo;
    }

    public RegionLoad getLoad() {
        return this.load;
    }

    public DrhCompactionScheduler<PK> getCompactionScheduler() {
        return this.compactionScheduler;
    }

    public void setBalancerDestinationServer(ServerName balancerDestinationServer) {
        this.balancerDestinationServer = Objects.requireNonNull(balancerDestinationServer);
    }

    public String toString() {
        return this.regionInfo.getEncodedName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (ClassTool.differentClass((Object)this, (Object)obj)) {
            return false;
        }
        DrRegionInfo that = (DrRegionInfo)obj;
        return Objects.equals(this.regionInfo.getEncodedName(), that.regionInfo.getEncodedName());
    }

    public int hashCode() {
        return this.regionInfo.getEncodedName().hashCode();
    }

    @Override
    public int compareTo(DrRegionInfo<?> other) {
        return Bytes.compareTo((byte[])this.regionInfo.getStartKey(), (byte[])other.getRegion().getStartKey());
    }
}

