/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.web;

import io.datarouter.client.hbase.config.DatarouterHBaseFiles;
import io.datarouter.client.hbase.config.DatarouterHBasePaths;
import io.datarouter.pathnode.PathNode;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientType;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import j2html.tags.specialized.DivTag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class HBaseWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private DatarouterHBaseFiles files;
    @Inject
    private DatarouterHBasePaths datarouterHBasePaths;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, ClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag clientPageHeader = this.buildClientPageHeader(clientName);
        DivTag clientOptionsTable = this.buildClientOptionsTable(allClientOptions);
        Mav mav = new Mav();
        mav.setViewName(this.files.jsp.admin.datarouter.hbase.hbaseClientSummaryJsp);
        mav.put("clientPageHeader", (Object)clientPageHeader.render());
        mav.put("clientOptionsTable", (Object)clientOptionsTable.render());
        return mav;
    }

    protected PathNode getHandlerPath() {
        return this.datarouterHBasePaths.datarouter.clients.hbase;
    }
}

