/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Bytes;
import io.datarouter.util.tuple.Range;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;

public class HBaseScanBuilder {
    private static final FirstKeyOnlyFilter FIRST_CELL_ONLY_FILTER = new FirstKeyOnlyFilter();
    private static final KeyOnlyFilter KEY_ONLY_FILTER = new KeyOnlyFilter();
    private Range<Bytes> range = Range.everything();
    private Integer limit;
    private FirstKeyOnlyFilter firstCellOnlyFilter;
    private KeyOnlyFilter keyOnlyFilter;
    private boolean startIsFullKey;

    public HBaseScanBuilder withRange(Range<Bytes> range) {
        this.range = range;
        return this;
    }

    public HBaseScanBuilder withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public HBaseScanBuilder withFirstKeyOnly(boolean firstKeyOnly) {
        if (firstKeyOnly) {
            this.firstCellOnlyFilter = FIRST_CELL_ONLY_FILTER;
            this.keyOnlyFilter = KEY_ONLY_FILTER;
        }
        return this;
    }

    public HBaseScanBuilder withStartIsFullKey(boolean startIsFullKey) {
        this.startIsFullKey = startIsFullKey;
        return this;
    }

    public Scan build() {
        Scan scan = this.getScanForRange();
        if (this.limit != null) {
            scan.setLimit(this.limit.intValue());
        }
        this.makeFilter().ifPresent(arg_0 -> ((Scan)scan).setFilter(arg_0));
        return scan;
    }

    private Scan getScanForRange() {
        byte[] start = this.getStart();
        byte[] endExclusive = this.getEndExclusive();
        Scan scan = new Scan();
        if (this.startIsFullKey || this.range.getStart() == null || this.range.getStartInclusive()) {
            scan.withStartRow(start, this.range.getStartInclusive());
        } else {
            scan.withStartRow(ByteTool.unsignedIncrement((byte[])start), true);
        }
        if (endExclusive.length > 0) {
            scan.withStopRow(endExclusive, false);
        }
        return scan;
    }

    private Optional<Filter> makeFilter() {
        FilterList filterList = new FilterList(new Filter[0]);
        if (this.firstCellOnlyFilter != null) {
            filterList.addFilter((Filter)this.firstCellOnlyFilter);
        }
        if (this.keyOnlyFilter != null) {
            filterList.addFilter((Filter)this.keyOnlyFilter);
        }
        if (this.limit != null) {
            filterList.addFilter((Filter)new PageFilter((long)this.limit.intValue()));
        }
        if (filterList.getFilters().isEmpty()) {
            return Optional.empty();
        }
        if (filterList.getFilters().size() == 1) {
            return Optional.of((Filter)filterList.getFilters().getFirst());
        }
        return Optional.of(filterList);
    }

    private byte[] getStart() {
        if (!this.range.hasStart()) {
            return new byte[0];
        }
        return ((Bytes)this.range.getStart()).toArray();
    }

    private byte[] getEndExclusive() {
        if (!this.range.hasEnd()) {
            return new byte[0];
        }
        if (this.range.getEndInclusive()) {
            return ByteTool.unsignedIncrement((byte[])((Bytes)this.range.getEnd()).toArray());
        }
        return ((Bytes)this.range.getEnd()).toArray();
    }
}

