/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.lang.ReflectionTool;
import java.lang.reflect.Field;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;

public class HBaseResultParser<EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final DatabeanFieldInfo<PK, D, F> fieldInfo;

    public HBaseResultParser(DatabeanFieldInfo<PK, D, F> fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    public PK toPk(byte[] row) {
        EntityPrimaryKey primaryKey = (EntityPrimaryKey)this.fieldInfo.getPrimaryKeySupplier().get();
        if (ArrayTool.isEmpty((byte[])row)) {
            return (PK)primaryKey;
        }
        int byteOffset = 0;
        for (io.datarouter.model.field.Field field : this.fieldInfo.getPrimaryKeyFields()) {
            int numBytesWithSeparator = field.numKeyBytesWithSeparator(row, byteOffset);
            Object value = field.fromKeyBytesWithSeparatorButDoNotSet(row, byteOffset);
            field.setUsingReflection((Object)primaryKey, value);
            byteOffset += numBytesWithSeparator;
        }
        return (PK)primaryKey;
    }

    public PK toPk(Result result) {
        return this.toPk(result.getRow());
    }

    public D toDatabean(Result result) {
        PK pk = this.toPk(result);
        Databean databean = (Databean)this.fieldInfo.getDatabeanSupplier().get();
        ReflectionTool.set((Field)this.fieldInfo.getKeyJavaField(), (Object)databean, pk);
        while (result.advance()) {
            io.datarouter.model.field.Field field;
            Cell cell = result.current();
            String qualifier = StringCodec.UTF_8.decode(CellUtil.cloneQualifier((Cell)cell));
            if (HBaseClientManager.DUMMY_COL_NAME.equals(qualifier) || (field = this.fieldInfo.getFieldForColumnName(qualifier)) == null) continue;
            Object value = field.fromValueBytesButDoNotSet(CellUtil.cloneValue((Cell)cell), 0);
            field.setUsingReflection((Object)databean, value);
        }
        return (D)databean;
    }
}

