/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.bytes.KvString;
import io.datarouter.bytes.codec.bytestringcodec.HexByteStringCodec;
import io.datarouter.gson.GsonTool;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.exception.DataAccessException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseReaderTool {
    private static final FirstKeyOnlyFilter FIRST_KEY_ONLY_FILTER = new FirstKeyOnlyFilter();
    private static final KeyOnlyFilter KEY_ONLY_FILTER = new KeyOnlyFilter();

    public static Result[] getUnchecked(Table table, List<Get> gets) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(table.getName()) + " get"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
                TracerTool.appendToSpanInfo((String)"gets", (Object)gets.size());
                Result[] results = table.get(gets);
                TracerTool.appendToSpanInfo((String)"results", (Object)results.length);
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public static void configureKeyOnlyFilter(Get get, boolean keysOnly) {
        if (keysOnly) {
            get.setFilter((Filter)new FilterList(new Filter[]{FIRST_KEY_ONLY_FILTER, KEY_ONLY_FILTER}));
        }
    }

    public static ResultScanner getResultScanner(Table table, Scan scan) throws IOException {
        byte[] start = scan.getStartRow();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)(String.valueOf(table.getName()) + " getScanner"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
                TracerTool.appendToSpanInfo((String)"start", (Object)Bytes.toStringBinary((byte[])start));
                return table.getScanner(scan);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            byte[] stop = scan.getStopRow();
            String message = new KvString().add("startString", Optional.ofNullable(start).map(Bytes::toStringBinary).orElse("null")).add("stopString", Optional.ofNullable(stop).map(Bytes::toStringBinary).orElse("null")).add("startHex", Optional.ofNullable(start).map(arg_0 -> ((HexByteStringCodec)HexByteStringCodec.INSTANCE).encode(arg_0)).orElse("null")).add("stopHex", Optional.ofNullable(stop).map(arg_0 -> ((HexByteStringCodec)HexByteStringCodec.INSTANCE).encode(arg_0)).orElse("null")).add("scan", GsonTool.forLogsPretty().toJson((Object)scan)).toString();
            throw new IOException(message, e);
        }
    }

    public static List<Result> resultScannerNext(ResultScanner resultScanner, int limit) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"ResultScanner next(limit)", (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            TracerTool.appendToSpanInfo((String)"limit", (Object)limit);
            Result[] results = resultScanner.next(limit);
            TracerTool.appendToSpanInfo((String)"results", (Object)results.length);
            return List.of(results);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

