/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node;

import io.datarouter.bytes.Bytes;
import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.util.HBaseQueryBuilder;
import io.datarouter.client.hbase.util.HBaseReaderTool;
import io.datarouter.client.hbase.util.HBaseResultParser;
import io.datarouter.client.hbase.util.HBaseScanBuilder;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.PagingScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientTableNodeNames;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.ScannerConfigTool;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.storage.node.op.raw.read.SortedStorageReader;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.util.Require;
import io.datarouter.util.tuple.Range;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;

public class HBaseReaderNode<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements MapStorageReader<PK, D>,
SortedStorageReader<PK, D> {
    private static final int DEFAULT_SCAN_BATCH_SIZE = 100;
    private static final Comparator<Result> RESULT_ROW_COMPARATOR = Comparator.comparing(Result::getRow, Arrays::compareUnsigned);
    private final HBaseClientManager hBaseClientManager;
    private final ClientType<?, ?> clientType;
    protected final ClientTableNodeNames clientTableNodeNames;
    protected final EntityFieldInfo<EK, E> entityFieldInfo;
    protected final HBaseQueryBuilder<EK, PK, D> queryBuilder;
    private final HBaseResultParser<EK, PK, D, F> resultParser;

    public HBaseReaderNode(HBaseClientManager hBaseClientManager, EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params, ClientType<?, ?> clientType) {
        super(params, clientType);
        this.hBaseClientManager = hBaseClientManager;
        this.clientType = clientType;
        this.clientTableNodeNames = new ClientTableNodeNames(this.getFieldInfo().getClientId(), this.getFieldInfo().getTableName(), this.getName());
        this.entityFieldInfo = new EntityFieldInfo(entityNodeParams);
        this.queryBuilder = new HBaseQueryBuilder();
        this.resultParser = new HBaseResultParser(this.getFieldInfo());
    }

    public boolean exists(PK key, Config config) {
        return this.getResults(Collections.singleton(key), config, true).hasAny();
    }

    public D get(PK key, Config config) {
        return (D)((Databean)this.getResults(Collections.singleton(key), config, false).map(this.resultParser::toDatabean).findFirst().orElse(null));
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.getResults(keys, config, false).map(this.resultParser::toDatabean).list();
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        return this.getResults(keys, config, true).map(this.resultParser::toPk).list();
    }

    private Scanner<Result> getResults(Collection<PK> keys, Config config, boolean keysOnly) {
        if (keys == null || keys.isEmpty()) {
            return Scanner.empty();
        }
        return Scanner.of(keys).map(this.queryBuilder::getPkBytes).map(Get::new).each(get -> HBaseReaderTool.configureKeyOnlyFilter(get, keysOnly)).batch(config.findRequestBatchSize().orElse(100).intValue()).map(gets -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Table table = this.getTable();){
                    return HBaseReaderTool.getUnchecked(table, gets);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).concat(resultArray -> Scanner.of((Object[])resultArray)).exclude(Result::isEmpty);
    }

    public Scanner<PK> scanKeys(Range<PK> range, Config config) {
        return this.scanResults(range, config, true).map(this.resultParser::toPk);
    }

    public Scanner<PK> scanRangesKeys(Collection<Range<PK>> ranges, Config config) {
        return this.scanRangesResults(ranges, config, true).map(this.resultParser::toPk);
    }

    public Scanner<D> scan(Range<PK> range, Config config) {
        return this.scanResults(range, config, false).map(this.resultParser::toDatabean);
    }

    public Scanner<D> scanRanges(Collection<Range<PK>> ranges, Config config) {
        return this.scanRangesResults(ranges, config, false).map(this.resultParser::toDatabean);
    }

    private Scanner<Result> scanRangesResults(Collection<Range<PK>> ranges, Config config, boolean keysOnly) {
        Config subscanConfig = config.clone().setOffset(Integer.valueOf(0));
        Scanner collated = Scanner.of(ranges).collate(range -> this.scanResults((Range<PK>)range, subscanConfig, keysOnly), RESULT_ROW_COMPARATOR);
        return ScannerConfigTool.applyOffsetAndLimit((Scanner)collated, (Config)config);
    }

    protected Scanner<Result> scanResults(Range<PK> range, Config config, boolean keysOnly) {
        if (HBaseQueryBuilder.isSingleRowRange(range)) {
            return this.getResults(Collections.singleton((EntityPrimaryKey)range.getStart()), config, keysOnly);
        }
        Range byteRange = range.map(this.queryBuilder::getPkByteRange);
        EntityPrimaryKey rangeStart = (EntityPrimaryKey)range.getStart();
        boolean startIsFullKey = range.hasStart() && FieldTool.countNonNullLeadingFields((List)rangeStart.getFields()) == rangeStart.getFields().size();
        int offset = config.findOffset().orElse(0);
        Integer subscanLimit = config.findLimit().map(limit -> offset + limit).orElse(null);
        int pageSize = config.findResponseBatchSize().orElse(100);
        Scanner<Result> results = this.scanResultsInByteRange((Range<Bytes>)byteRange, pageSize, subscanLimit, keysOnly, startIsFullKey);
        return ScannerConfigTool.applyOffsetAndLimit(results, (Config)config);
    }

    private Scanner<Result> scanResultsInByteRange(Range<Bytes> range, int pageSize, Integer limit, boolean keysOnly, boolean startIsFullKey) {
        if (range.isEmpty()) {
            return Scanner.empty();
        }
        ResultPagingScanner pagingScanner = new ResultPagingScanner(pageSize, range, limit, keysOnly, startIsFullKey);
        return pagingScanner.concat(Scanner::of);
    }

    /*
     * Loose catch block
     */
    private List<Result> getPageOfResults(Range<Bytes> rowRange, boolean keysOnly, int limit, boolean startIsFullKey) throws IOException {
        Scan scan = new HBaseScanBuilder().withRange(rowRange).withFirstKeyOnly(keysOnly).withLimit(limit).withStartIsFullKey(startIsFullKey).build();
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            List<Result> list;
            ResultScanner resultScanner;
            Table table;
            block16: {
                block15: {
                    table = this.getTable();
                    resultScanner = HBaseReaderTool.getResultScanner(table, scan);
                    List<Result> results = HBaseReaderTool.resultScannerNext(resultScanner, limit);
                    this.countPage(keysOnly, results.size());
                    list = results;
                    if (resultScanner == null) break block15;
                    resultScanner.close();
                }
                if (table == null) break block16;
                table.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (resultScanner != null) {
                            resultScanner.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (table != null) {
                            table.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected Table getTable() {
        return this.hBaseClientManager.getTable(this.getClientId(), this.clientTableNodeNames.getTableName());
    }

    private void countPage(boolean keysOnly, int numResults) {
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)("scan " + (keysOnly ? "key" : "row") + " numRows"), (String)this.getClientId().getName(), (String)this.getName(), (long)numResults);
    }

    private class ResultPagingScanner
    extends PagingScanner<Bytes, Result> {
        private final Range<Bytes> mutableRange;
        private final boolean keysOnly;
        private final Optional<Integer> limit;
        private long numFetched;
        private boolean startIsFullKey;
        private volatile boolean closed;

        public ResultPagingScanner(int pageSize, Range<Bytes> range, Integer limit, boolean keysOnly, boolean startIsFullKey) {
            super(pageSize);
            this.startIsFullKey = startIsFullKey;
            this.mutableRange = range.clone();
            this.keysOnly = keysOnly;
            this.limit = Optional.ofNullable(limit);
            this.numFetched = 0L;
            this.closed = false;
        }

        protected Optional<Bytes> nextParam(Result lastSeenItem) {
            if (lastSeenItem == null) {
                return Optional.empty();
            }
            byte[] row = lastSeenItem.getRow();
            Bytes bytes = new Bytes(row);
            return Optional.of(bytes);
        }

        protected List<Result> nextPage(Optional<Bytes> resumeFrom) {
            Require.isFalse((boolean)this.closed, (String)"don't call me, i'm closed");
            if (this.limit.isPresent() && this.numFetched >= (long)this.limit.get().intValue()) {
                return List.of();
            }
            if (resumeFrom.isPresent()) {
                this.mutableRange.setStart((Object)resumeFrom.get());
                this.mutableRange.setStartInclusive(false);
                this.startIsFullKey = true;
            }
            int pageLimit = this.pageSize;
            if (this.limit.isPresent()) {
                long numRemaining = (long)this.limit.get().intValue() - this.numFetched;
                pageLimit = Math.min(this.pageSize, (int)numRemaining);
            }
            try {
                List<Result> page = HBaseReaderNode.this.getPageOfResults(this.mutableRange, this.keysOnly, pageLimit, this.startIsFullKey);
                this.numFetched += (long)page.size();
                return page;
            }
            catch (IOException e) {
                if (this.closed) {
                    return List.of();
                }
                throw new RuntimeException("", e);
            }
        }

        public void close() {
            this.closed = true;
        }
    }
}

