/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.node.HBaseReaderNode;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.exception.DataAccessException;
import io.datarouter.model.field.Field;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.util.tuple.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Table;

public class HBaseNode<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends HBaseReaderNode<EK, E, PK, D, F>
implements SortedMapStorage.PhysicalSortedMapStorageNode<PK, D, F> {
    private final ClientType<?, ?> clientType;

    public HBaseNode(HBaseClientManager hBaseClientManager, ClientType<?, ?> clientType, EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params) {
        super(hBaseClientManager, entityNodeParams, params, clientType);
        this.clientType = clientType;
    }

    public void put(D databean, Config config) {
        this.putMulti(List.of(databean), config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        ActionBatch batch = (ActionBatch)Scanner.of(databeans).map(databean -> this.makePutAndDelete(databean)).listTo(ActionBatch::new);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"HBase putMulti", (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            this.traceAndCount(batch.actions.size(), batch.numCellsPut, batch.numCellsDeleted, batch.putBytes, batch.putValueBytes, batch.deleteBytes);
            this.execute(batch.actions);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private PutAndDelete makePutAndDelete(D databean) {
        byte[] keyBytes = this.queryBuilder.getPkBytes((EntityPrimaryKey)databean.getKey());
        Put put = new Put(keyBytes);
        Delete delete = new Delete(keyBytes);
        int numCellsPut = 0;
        int numCellsDeleted = 0;
        int putBytes = 0;
        int putValueBytes = 0;
        int deleteBytes = 0;
        for (Field field : this.getFieldInfo().getNonKeyFieldsWithValues(databean)) {
            field.getKey().getColumnNameBytes();
            byte[] columnNameBytes = field.getKey().getColumnNameBytes();
            byte[] valueBytes = field.getValueBytes();
            if (valueBytes == null) {
                delete.addColumns(HBaseClientManager.DEFAULT_FAMILY_QUALIFIER, columnNameBytes);
                deleteBytes += columnNameBytes.length;
                ++numCellsDeleted;
                continue;
            }
            put.addColumn(HBaseClientManager.DEFAULT_FAMILY_QUALIFIER, columnNameBytes, valueBytes);
            putBytes += columnNameBytes.length;
            putValueBytes += valueBytes.length;
            ++numCellsPut;
        }
        if (put.isEmpty()) {
            byte[] columnNameBytes = HBaseClientManager.DUMMY_COL_NAME_BYTES;
            byte[] valueBytes = HBaseClientManager.DUMMY_FIELD_VALUE;
            put.addColumn(HBaseClientManager.DEFAULT_FAMILY_QUALIFIER, columnNameBytes, valueBytes);
            putBytes += columnNameBytes.length;
            putValueBytes += valueBytes.length;
            ++numCellsPut;
        }
        return new PutAndDelete(put, delete, numCellsPut, numCellsDeleted, putBytes, putValueBytes, deleteBytes);
    }

    private void traceAndCount(int numActions, int numCellsPut, int numCellsDeleted, int putBytes, int putValueBytes, int deleteBytes) {
        TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("actions", (Object)numActions).add("cellsPut", (Object)numCellsPut).add("cellsDeleted", (Object)numCellsDeleted).add("putBytes", (Object)putBytes).add("putValueBytes", (Object)putValueBytes).add("deleteBytes", (Object)deleteBytes));
        String clientName = this.clientTableNodeNames.getClientName();
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"put rpc", (String)clientName, (String)this.getName(), (long)1L);
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells put", (String)clientName, (String)this.getName(), (long)numCellsPut);
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells delete", (String)clientName, (String)this.getName(), (long)numCellsDeleted);
    }

    public void deleteAll(Config config) {
        this.scanResults(Range.everything(), config, true).map(Result::getRow).map(Delete::new).batch(config.findRequestBatchSize().orElse(100).intValue()).forEach(actions -> this.execute((List<? extends Row>)actions));
    }

    public void delete(PK key, Config config) {
        this.deleteMulti(List.of(key), config);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        List deletes = Scanner.of(keys).map(this.queryBuilder::getPkBytes).map(Delete::new).list();
        Throwable throwable = null;
        Object var6_6 = null;
        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"HBase deleteMulti", (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
            TracerTool.appendToSpanInfo((String)"keys", (Object)deletes.size());
            this.execute(deletes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void execute(List<? extends Row> actions) {
        if (actions.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Table table = this.getTable();){
                table.batch(actions, new Object[actions.size()]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private static class ActionBatch {
        public final List<Row> actions = new ArrayList<Row>();
        public int numCellsPut = 0;
        public int numCellsDeleted = 0;
        public int putBytes = 0;
        public int putValueBytes = 0;
        public int deleteBytes = 0;

        public ActionBatch(List<PutAndDelete> putAndDeletes) {
            for (PutAndDelete putAndDelete : putAndDeletes) {
                this.actions.add((Row)putAndDelete.put);
                if (!putAndDelete.delete.isEmpty()) {
                    this.actions.add((Row)putAndDelete.delete);
                }
                this.numCellsPut += putAndDelete.numCellsPut;
                this.numCellsDeleted += putAndDelete.numCellsDeleted;
                this.putBytes += putAndDelete.putBytes;
                this.putValueBytes += putAndDelete.putValueBytes;
                this.deleteBytes += putAndDelete.deleteBytes;
            }
        }
    }

    private record PutAndDelete(Put put, Delete delete, int numCellsPut, int numCellsDeleted, int putBytes, int putValueBytes, int deleteBytes) {
    }
}

