/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.client;

import io.datarouter.storage.client.ClientId;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.client.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HBaseConnectionHolder {
    private static final Logger logger = LoggerFactory.getLogger(HBaseConnectionHolder.class);
    private final Map<ClientId, Connection> connectionByClientId = new ConcurrentHashMap<ClientId, Connection>();

    public void register(ClientId clientId, Connection connection) {
        if (this.connectionByClientId.containsKey(clientId)) {
            throw new RuntimeException(String.valueOf(clientId) + " already registered a connection");
        }
        this.connectionByClientId.put(clientId, connection);
    }

    public Connection getConnection(ClientId clientId) {
        return this.connectionByClientId.get(clientId);
    }

    public void closeConnection(ClientId clientId) {
        try {
            this.connectionByClientId.get(clientId).close();
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
    }
}

