/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.client;

import io.datarouter.client.hbase.client.HBaseOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import io.datarouter.storage.config.client.HBaseGenericClientOptions;
import java.util.Properties;

public class HBaseClientOptionsBuilder
implements ClientOptionsBuilder {
    protected final String clientIdName;
    protected final Properties properties;

    public HBaseClientOptionsBuilder(ClientId clientId) {
        this(clientId, "hbase");
    }

    public HBaseClientOptionsBuilder(HBaseGenericClientOptions genericOptions) {
        this(genericOptions.clientId);
        this.withZookeeperQuorum(genericOptions.zookeeperQuorum);
    }

    protected HBaseClientOptionsBuilder(ClientId clientId, String clientTypeName) {
        this.clientIdName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(ClientOptions.makeClientTypeKey((String)this.clientIdName), clientTypeName);
    }

    public HBaseClientOptionsBuilder withZookeeperQuorum(String zookeeperQuorum) {
        String optionKeySuffix = HBaseOptions.makeHbaseKey("zookeeper.quorum");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, zookeeperQuorum);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    protected String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientIdName, (String)suffix);
    }
}

