/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase;

import io.datarouter.client.hbase.HBaseSchemaUpdateService;
import io.datarouter.client.hbase.client.HBaseConnectionHolder;
import io.datarouter.client.hbase.client.HBaseOptions;
import io.datarouter.storage.client.BaseClientManager;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.schema.SchemaUpdateOptions;
import io.datarouter.storage.config.schema.SchemaUpdateResult;
import io.datarouter.storage.exception.UnavailableException;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.timer.PhaseTimer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HBaseClientManager
extends BaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(HBaseClientManager.class);
    public static final byte[] DEFAULT_FAMILY_QUALIFIER = new byte[]{97};
    public static final byte[] DUMMY_COL_NAME_BYTES = new byte[1];
    public static final String DUMMY_COL_NAME = new String(DUMMY_COL_NAME_BYTES);
    public static final byte[] DUMMY_FIELD_VALUE = new byte[]{-128};
    @Inject
    private SchemaUpdateOptions schemaUpdateOptions;
    @Inject
    private HBaseConnectionHolder hbaseConnectionHolder;
    @Inject
    private HBaseOptions hbaseOptions;
    @Inject
    private HBaseSchemaUpdateService hbaseSchemaUpdateService;

    protected void safeInitClient(ClientId clientId) {
        logger.info("activating HBase client " + clientId.getName());
        PhaseTimer timer = new PhaseTimer(clientId.getName());
        Connection connection = this.makeConnection(clientId.getName());
        this.hbaseConnectionHolder.register(clientId, connection);
        timer.add("init hbase connection");
        logger.warn(timer.add("done").toString());
    }

    public Connection getConnection(ClientId clientId) {
        this.initClient(clientId);
        return this.hbaseConnectionHolder.getConnection(clientId);
    }

    public Table getTable(ClientId clientId, String tableName) {
        try {
            return this.getConnection(clientId).getTable(TableName.valueOf((String)tableName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Connection makeConnection(String clientName) {
        Connection connection;
        String zkQuorum = this.hbaseOptions.zookeeperQuorum(clientName);
        Configuration hbaseConfig = HBaseConfiguration.create();
        hbaseConfig.set("hbase.zookeeper.quorum", zkQuorum);
        try {
            connection = ConnectionFactory.createConnection((Configuration)hbaseConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (connection.isClosed()) {
            String log = "couldn't open connection because hBaseAdmin.getConnection().isClosed()";
            logger.warn(log);
            throw new UnavailableException(log);
        }
        return connection;
    }

    protected Future<Optional<SchemaUpdateResult>> doSchemaUpdate(PhysicalNode<?, ?, ?> node) {
        if (this.schemaUpdateOptions.getEnabled()) {
            return this.hbaseSchemaUpdateService.queueNodeForSchemaUpdate(node.getFieldInfo().getClientId(), node);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    public void shutdown(ClientId clientId) {
        this.hbaseSchemaUpdateService.gatherSchemaUpdates(true);
        this.hbaseConnectionHolder.closeConnection(clientId);
        this.eagerlyInitializeShutdownHookManager();
    }

    private void eagerlyInitializeShutdownHookManager() {
        ReflectionTool.invoke((Object)ShutdownHookManager.get(), (String)"getShutdownHooksInOrder", (Object[])new Object[0]);
    }
}

