/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.pool;

import io.datarouter.client.hbase.client.HBaseConnectionHolder;
import io.datarouter.client.hbase.client.HBaseOptions;
import io.datarouter.client.hbase.config.DatarouterHBaseSettingRoot;
import io.datarouter.client.hbase.pool.HBaseTablePool;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.client.Connection;

@Singleton
public class HBaseTablePoolHolder {
    @Inject
    private HBaseOptions hBaseOptions;
    @Inject
    private DatarouterHBaseSettingRoot datarouterHBaseSettingRoot;
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private HBaseConnectionHolder hBaseConnectionHolder;
    private final Map<ClientId, HBaseTablePool> hBasetablePoolsByClientId = new ConcurrentHashMap<ClientId, HBaseTablePool>();

    public void register(ClientId clientId, Connection connection) {
        this.hBaseConnectionHolder.register(clientId, connection);
        if (this.hBasetablePoolsByClientId.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered an HBaseTablePool");
        }
        ClientType clientType = this.datarouterClients.getClientTypeInstance(clientId);
        HBaseTablePool hBaseTablePool = new HBaseTablePool(this.hBaseOptions, this.datarouterHBaseSettingRoot, connection, clientId, clientType);
        this.hBasetablePoolsByClientId.put(clientId, hBaseTablePool);
    }

    public HBaseTablePool getHBaseTablePool(ClientId clientId) {
        return this.hBasetablePoolsByClientId.get(clientId);
    }
}

