/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.nonentity;

import io.datarouter.bytes.Bytes;
import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.config.DatarouterHBaseExecutors;
import io.datarouter.client.hbase.node.nonentity.HBaseNonEntityQueryBuilder;
import io.datarouter.client.hbase.node.nonentity.HBaseNonEntityResultParser;
import io.datarouter.client.hbase.util.HBaseResultComparator;
import io.datarouter.client.hbase.util.HBaseResultScannerTool;
import io.datarouter.client.hbase.util.HBaseScanBuilder;
import io.datarouter.client.hbase.util.HBaseTableTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.PagingScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientTableNodeNames;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.ScannerConfigTool;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.read.MapStorageReader;
import io.datarouter.storage.node.op.raw.read.SortedStorageReader;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.util.Require;
import io.datarouter.util.tuple.Range;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;

public class HBaseReaderNode<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements MapStorageReader<PK, D>,
SortedStorageReader<PK, D> {
    private static final int DEFAULT_SCAN_BATCH_SIZE = 100;
    private static final boolean DEFAULT_ENABLE_SCANNER_PREFETCH = false;
    private static final boolean DEFAULT_ENABLE_SCANNER_CACHING = true;
    private static final FirstKeyOnlyFilter FIRST_KEY_ONLY_FILTER = new FirstKeyOnlyFilter();
    private static final KeyOnlyFilter KEY_ONLY_FILTER = new KeyOnlyFilter();
    private final HBaseClientManager hBaseClientManager;
    private final ClientType<?, ?> clientType;
    private final DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor;
    protected final ClientTableNodeNames clientTableNodeNames;
    protected final EntityFieldInfo<EK, E> entityFieldInfo;
    protected final EntityPartitioner<EK> partitioner;
    protected final HBaseNonEntityQueryBuilder<EK, PK, D> queryBuilder;
    private final HBaseResultComparator resultComparator;
    private final HBaseNonEntityResultParser<EK, PK, D, F> resultParser;

    public HBaseReaderNode(HBaseClientManager hBaseClientManager, EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params, ClientType<?, ?> clientType, DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor) {
        super(params, clientType);
        this.hBaseClientManager = hBaseClientManager;
        this.clientType = clientType;
        this.datarouterHbaseClientExecutor = datarouterHbaseClientExecutor;
        this.clientTableNodeNames = new ClientTableNodeNames(this.getFieldInfo().getClientId(), this.getFieldInfo().getTableName(), this.getName());
        this.entityFieldInfo = new EntityFieldInfo(entityNodeParams);
        this.partitioner = this.entityFieldInfo.getEntityPartitioner();
        this.queryBuilder = new HBaseNonEntityQueryBuilder(this.partitioner);
        this.resultComparator = new HBaseResultComparator(this.partitioner.getNumPrefixBytes());
        this.resultParser = new HBaseNonEntityResultParser(this.partitioner, this.getFieldInfo());
    }

    public boolean exists(PK key, Config config) {
        return this.getResults(Collections.singleton(key), config, true).hasAny();
    }

    public D get(PK key, Config config) {
        return (D)((Databean)this.getResults(Collections.singleton(key), config, false).map(this.resultParser::toDatabean).findFirst().orElse(null));
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.getResults(keys, config, false).map(this.resultParser::toDatabean).list();
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        return this.getResults(keys, config, true).map(this.resultParser::toPk).list();
    }

    private Scanner<Result> getResults(Collection<PK> keys, Config config, boolean keysOnly) {
        if (keys == null || keys.isEmpty()) {
            return Scanner.empty();
        }
        return Scanner.of(keys).map(this.queryBuilder::getPkBytesWithPartition).map(Get::new).each(get -> HBaseReaderNode.configureKeyOnlyFilter(get, keysOnly)).batch(config.findRequestBatchSize().orElse(100).intValue()).map(gets -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Table table = this.getTable();){
                    return HBaseTableTool.getUnchecked(table, gets);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).concat(resultArray -> Scanner.of((Object[])resultArray)).exclude(Result::isEmpty);
    }

    private static void configureKeyOnlyFilter(Get get, boolean keysOnly) {
        if (keysOnly) {
            get.setFilter((Filter)new FilterList(new Filter[]{FIRST_KEY_ONLY_FILTER, KEY_ONLY_FILTER}));
        }
    }

    public Scanner<PK> scanKeys(Range<PK> range, Config config) {
        return this.scanResults(range, config, true).map(this.resultParser::toPk);
    }

    public Scanner<PK> scanRangesKeys(Collection<Range<PK>> ranges, Config config) {
        return this.scanRangesResults(ranges, config, true).map(this.resultParser::toPk);
    }

    public Scanner<D> scan(Range<PK> range, Config config) {
        return this.scanResults(range, config, false).map(this.resultParser::toDatabean);
    }

    public Scanner<D> scanRanges(Collection<Range<PK>> ranges, Config config) {
        return this.scanRangesResults(ranges, config, false).map(this.resultParser::toDatabean);
    }

    private Scanner<Result> scanRangesResults(Collection<Range<PK>> ranges, Config config, boolean keysOnly) {
        Config subscanConfig = config.clone().setOffset(Integer.valueOf(0));
        Scanner collated = Scanner.of(ranges).collate(range -> this.scanResults((Range<PK>)range, subscanConfig, keysOnly), (Comparator)this.resultComparator);
        return ScannerConfigTool.applyOffsetAndLimit((Scanner)collated, (Config)config);
    }

    protected Scanner<Result> scanResults(Range<PK> range, Config config, boolean keysOnly) {
        if (HBaseNonEntityQueryBuilder.isSingleRowRange(range)) {
            return this.getResults(Collections.singleton((EntityPrimaryKey)range.getStart()), config, keysOnly);
        }
        Range byteRange = range.map(this.queryBuilder::getPkByteRange);
        EntityPrimaryKey rangeStart = (EntityPrimaryKey)range.getStart();
        boolean startIsFullKey = range.hasStart() && FieldTool.countNonNullLeadingFields((List)rangeStart.getFields()) == rangeStart.getFields().size();
        int offset = config.findOffset().orElse(0);
        Integer subscanLimit = config.findLimit().map(limit -> offset + limit).orElse(null);
        int pageSize = config.findResponseBatchSize().orElse(100);
        boolean prefetch = config.findScannerPrefetching().orElse(false);
        boolean cacheBlocks = config.findScannerCaching().orElse(true);
        Scanner collatedPartitions = this.partitioner.scanPrefixes(range).collate(prefix -> this.scanResultsInByteRange((byte[])prefix, (Range<Bytes>)byteRange, pageSize, subscanLimit, prefetch, cacheBlocks, keysOnly, startIsFullKey), (Comparator)this.resultComparator);
        return ScannerConfigTool.applyOffsetAndLimit((Scanner)collatedPartitions, (Config)config);
    }

    private Scanner<Result> scanResultsInByteRange(byte[] prefix, Range<Bytes> range, int pageSize, Integer limit, boolean prefetch, boolean cacheBlocks, boolean keysOnly, boolean startIsFullKey) {
        if (range.isEmpty()) {
            return Scanner.empty();
        }
        ResultPagingScanner pagingScanner = new ResultPagingScanner(pageSize, prefix, range, limit, cacheBlocks, keysOnly, startIsFullKey);
        Scanner results = pagingScanner.concat(Scanner::of);
        if (prefetch) {
            results = results.prefetch((ExecutorService)((Object)this.datarouterHbaseClientExecutor), pageSize);
        }
        return results;
    }

    /*
     * Loose catch block
     */
    private List<Result> getPageOfResults(byte[] prefix, Range<Bytes> rowRange, boolean keysOnly, int limit, boolean cacheBlocks, boolean startIsFullKey) throws IOException {
        Scan scan = new HBaseScanBuilder().withPrefix(prefix).withRange(rowRange).withFirstKeyOnly(keysOnly).withLimit(limit).withCacheBlocks(cacheBlocks).withStartIsFullKey(startIsFullKey).build();
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            List<Result> list;
            ResultScanner resultScanner;
            Table table;
            block16: {
                block15: {
                    table = this.getTable();
                    resultScanner = HBaseTableTool.getResultScanner(table, scan);
                    List<Result> results = HBaseResultScannerTool.resultScannerNext(resultScanner, limit);
                    this.countPage(keysOnly, results.size());
                    list = results;
                    if (resultScanner == null) break block15;
                    resultScanner.close();
                }
                if (table == null) break block16;
                table.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (resultScanner != null) {
                            resultScanner.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (table != null) {
                            table.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected Table getTable() {
        return this.hBaseClientManager.getTable(this.getClientId(), this.clientTableNodeNames.getTableName());
    }

    public EntityFieldInfo<EK, E> getEntityFieldInfo() {
        return this.entityFieldInfo;
    }

    public ClientTableNodeNames getClientTableNodeNames() {
        return this.clientTableNodeNames;
    }

    public HBaseNonEntityResultParser<EK, PK, D, F> getResultParser() {
        return this.resultParser;
    }

    private void countPage(boolean keysOnly, int numResults) {
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)("scan " + (keysOnly ? "key" : "row") + " numRows"), (String)this.getClientId().getName(), (String)this.getName(), (long)numResults);
    }

    private class ResultPagingScanner
    extends PagingScanner<Bytes, Result> {
        private final byte[] prefix;
        private final Range<Bytes> mutableRange;
        private final boolean keysOnly;
        private final Optional<Integer> limit;
        private final boolean cacheBlocks;
        private long numFetched;
        private boolean startIsFullKey;
        private volatile boolean closed;

        public ResultPagingScanner(int pageSize, byte[] prefix, Range<Bytes> range, Integer limit, boolean cacheBlocks, boolean keysOnly, boolean startIsFullKey) {
            super(pageSize);
            this.prefix = prefix;
            this.startIsFullKey = startIsFullKey;
            this.mutableRange = range.clone();
            this.keysOnly = keysOnly;
            this.limit = Optional.ofNullable(limit);
            this.cacheBlocks = cacheBlocks;
            this.numFetched = 0L;
            this.closed = false;
        }

        protected Optional<Bytes> nextParam(Result lastSeenItem) {
            if (lastSeenItem == null) {
                return Optional.empty();
            }
            byte[] rowWithoutPrefix = HBaseReaderNode.this.resultParser.rowWithoutPrefix(lastSeenItem.getRow());
            Bytes bytes = new Bytes(rowWithoutPrefix);
            return Optional.of(bytes);
        }

        protected List<Result> nextPage(Optional<Bytes> resumeFrom) {
            Require.isFalse((boolean)this.closed, (String)"don't call me, i'm closed");
            if (this.limit.isPresent() && this.numFetched >= (long)this.limit.get().intValue()) {
                return List.of();
            }
            if (resumeFrom.isPresent()) {
                this.mutableRange.setStart((Object)resumeFrom.get());
                this.mutableRange.setStartInclusive(false);
                this.startIsFullKey = true;
            }
            int pageLimit = this.pageSize;
            if (this.limit.isPresent()) {
                long numRemaining = (long)this.limit.get().intValue() - this.numFetched;
                pageLimit = Math.min(this.pageSize, (int)numRemaining);
            }
            try {
                List<Result> page = HBaseReaderNode.this.getPageOfResults(this.prefix, this.mutableRange, this.keysOnly, pageLimit, this.cacheBlocks, this.startIsFullKey);
                this.numFetched += (long)page.size();
                return page;
            }
            catch (IOException e) {
                if (this.closed) {
                    return List.of();
                }
                throw new RuntimeException("", e);
            }
        }

        public void close() {
            this.closed = true;
        }
    }
}

