/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.nonentity;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Bytes;
import io.datarouter.bytes.EmptyArray;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.tuple.Range;
import java.util.List;
import java.util.Objects;

public class HBaseNonEntityQueryBuilder<EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>> {
    private final EntityPartitioner<EK> partitioner;

    public HBaseNonEntityQueryBuilder(EntityPartitioner<EK> partitioner) {
        this.partitioner = partitioner;
    }

    public static <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>> boolean isSingleRowRange(Range<PK> range) {
        return range.hasStart() && range.equalsStartEnd() && range.getStartInclusive() && range.getEndInclusive() && Scanner.of((Iterable)((EntityPrimaryKey)range.getStart()).getFieldValues()).noneMatch(Objects::isNull);
    }

    private byte[] getEkBytes(EK ek) {
        return HBaseNonEntityQueryBuilder.getConcatenatedValueBytesUnterminated(ek.getFields());
    }

    private byte[] getPkBytes(PK pk) {
        return HBaseNonEntityQueryBuilder.getConcatenatedValueBytesUnterminated(pk.getFields());
    }

    public byte[] getPkBytesWithPartition(PK pk) {
        byte[] prefix = this.partitioner.getPrefix(pk.getEntityKey());
        return ByteTool.concat((byte[][])new byte[][]{prefix, this.getPkBytes(pk)});
    }

    public Bytes getEkByteRange(EK ek) {
        return ek == null ? null : new Bytes(this.getEkBytes(ek));
    }

    public Bytes getPkByteRange(PK pk) {
        if (pk == null) {
            return null;
        }
        byte[] pkBytes = this.getPkBytes(pk);
        if (pkBytes == null) {
            return null;
        }
        return new Bytes(pkBytes);
    }

    @Deprecated
    public static byte[] getConcatenatedValueBytesUnterminated(List<Field<?>> fields) {
        int numTokens = FieldTool.countNonNullLeadingFields(fields);
        if (numTokens == 0) {
            return EmptyArray.BYTE;
        }
        byte[][] tokens = new byte[numTokens][];
        int i = 0;
        while (i < numTokens) {
            Field<?> field = fields.get(i);
            boolean finalField = i == fields.size() - 1;
            tokens[i] = finalField ? field.getValueBytes() : field.getKeyBytesWithSeparator();
            ++i;
        }
        return ByteTool.concat((byte[][])tokens);
    }
}

