/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.compaction;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.balancer.HBaseBalancerFactory;
import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.client.hbase.cluster.DrRegionListFactory;
import io.datarouter.client.hbase.cluster.DrServerList;
import io.datarouter.client.hbase.compaction.DrhCompactionScheduler;
import io.datarouter.client.hbase.compaction.HBaseCompactionInfo;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.util.timer.PhaseTimer;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.hbase.client.Admin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseCompactionJob
extends BaseJob {
    private static final Logger logger = LoggerFactory.getLogger(HBaseCompactionJob.class);
    @Inject
    private DatarouterNodes nodes;
    @Inject
    private HBaseBalancerFactory balancerFactory;
    @Inject
    private HBaseCompactionInfo compactionInfo;
    @Inject
    private DrRegionListFactory drRegionListFactory;
    @Inject
    private HBaseClientManager hBaseClientManager;
    private final LongAdder numTables = new LongAdder();
    private final LongAdder numRegions = new LongAdder();
    private final LongAdder numMissingLoad = new LongAdder();
    private final LongAdder numAlreadyLocal = new LongAdder();
    private final LongAdder numTriggered = new LongAdder();

    public void run(TaskTracker tracker) {
        for (ClientId clientId : this.compactionInfo.getManagedClientIds()) {
            Admin admin = this.hBaseClientManager.getAdmin(clientId);
            DrServerList servers = new DrServerList(admin);
            List tableNames = this.nodes.getTableNamesForClient(clientId.getName());
            for (String tableName : tableNames) {
                if (tracker.heartbeat(this.numRegions.sum()).shouldStop()) {
                    return;
                }
                try {
                    this.compactTable(tracker, admin, servers, clientId, tableName);
                }
                catch (Exception e) {
                    logger.warn("error compacting {}.{}", new Object[]{clientId, tableName, e});
                }
            }
        }
        logger.warn("numTables={}, numRegions={}, numMissingLoad={}, numAlreadyLocal={}, numTriggered={}", new Object[]{this.numTables, this.numRegions, this.numMissingLoad, this.numAlreadyLocal, this.numTriggered});
    }

    private void compactTable(TaskTracker tracker, Admin admin, DrServerList servers, ClientId clientId, String tableName) {
        this.numTables.increment();
        PhysicalNode physicalNodeForTable = this.nodes.getPhysicalNodeForClientAndTable(clientId.getName(), tableName);
        if (physicalNodeForTable == null) {
            logger.error("physicalNode not found for table " + tableName);
            return;
        }
        DrRegionListFactory.DrRegionList regionList = this.drRegionListFactory.make(clientId, servers, tableName, physicalNodeForTable, this.balancerFactory.getBalancerForTable(clientId, tableName));
        LongAdder numRegionsTriggeredInTable = new LongAdder();
        for (DrRegionInfo<?> region : regionList.getRegions()) {
            if (tracker.heartbeat(this.numRegions.sum()).shouldStop()) {
                return;
            }
            this.numRegions.increment();
            if (region.getLoad() == null) {
                this.numMissingLoad.increment();
                logger.warn("region.getLoad()==null on {} {}", (Object)region.getTableName(), (Object)region.getName());
                continue;
            }
            if (region.getLoad().getDataLocality() == 1.0f) {
                this.numAlreadyLocal.increment();
                continue;
            }
            DrhCompactionScheduler scheduler = new DrhCompactionScheduler(this.compactionInfo, region);
            if (!scheduler.shouldCompact()) continue;
            this.compactRegion(admin, region, numRegionsTriggeredInTable);
        }
    }

    private void compactRegion(Admin admin, DrRegionInfo<?> region, LongAdder numRegionsTriggeredInTable) {
        this.numTriggered.increment();
        numRegionsTriggeredInTable.increment();
        PhaseTimer timer = new PhaseTimer("compact " + numRegionsTriggeredInTable + " of " + region.getTableName());
        String encodedRegionNameString = region.getRegion().getEncodedName();
        try {
            admin.majorCompactRegion(region.getRegion().getRegionName());
            Object startKey = region.getStartKeyString();
            String timerMessage = String.format("major_compact server=%s table=%s region=%s startKey=%s ", region.getServerName(), region.getTableName(), encodedRegionNameString, startKey);
            timer.add(timerMessage);
            logger.warn(timer.toString());
        }
        catch (Exception e) {
            logger.warn("failed to compact region:{} because of:", (Object)encodedRegionNameString, (Object)e);
        }
    }
}

