/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.cluster;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.balancer.BaseHBaseRegionBalancer;
import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.client.hbase.cluster.DrServerInfo;
import io.datarouter.client.hbase.cluster.DrServerList;
import io.datarouter.client.hbase.compaction.HBaseCompactionInfo;
import io.datarouter.client.hbase.util.HBaseClientTool;
import io.datarouter.model.exception.DataAccessException;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.util.concurrent.CallableTool;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrRegionListFactory {
    private static final Logger logger = LoggerFactory.getLogger(DrRegionList.class);
    @Inject
    private HBaseClientManager hBaseClientManager;
    @Inject
    private HBaseCompactionInfo compactionInfo;

    public DrRegionList make(ClientId clientId, DrServerList servers, String tableName, PhysicalNode<?, ?, ?> node, BaseHBaseRegionBalancer balancer) {
        ArrayList regions = new ArrayList();
        EntityFieldInfo<?, ?> entityFieldInfo = HBaseClientTool.getEntityFieldInfo(node);
        EntityPartitioner entityPartitioner = entityFieldInfo.getEntityPartitioner();
        Map<HRegionInfo, ServerName> serverNameByHRegionInfo = this.getServerNameByHRegionInfo(clientId, tableName);
        TreeMap<String, RegionLoad> regionLoadByName = new TreeMap<String, RegionLoad>();
        for (DrServerInfo server : servers.getServers()) {
            ServerLoad serverLoad = server.getServerLoad();
            Map map = serverLoad.getRegionsLoad();
            for (RegionLoad regionLoad : map.values()) {
                String name = HRegionInfo.encodeRegionName((byte[])regionLoad.getName());
                regionLoadByName.put(name, regionLoad);
            }
        }
        int regionNum = 0;
        for (HRegionInfo hregionInfo : serverNameByHRegionInfo.keySet()) {
            try {
                RegionLoad regionLoad = (RegionLoad)regionLoadByName.get(hregionInfo.getEncodedName());
                ServerName serverName = serverNameByHRegionInfo.get(hregionInfo);
                regions.add(new DrRegionInfo(regionNum++, tableName, hregionInfo, serverName, node, regionLoad, this.compactionInfo, entityFieldInfo));
            }
            catch (RuntimeException runtimeException) {
                logger.warn("couldn't build DRHRegionList for region:" + hregionInfo.getEncodedName());
                throw runtimeException;
            }
        }
        Collections.sort(regions);
        DrRegionList drRegionList = new DrRegionList(regions);
        balancer.init(entityPartitioner, servers, drRegionList);
        logger.info("starting balancerStrategy for {} with {} regions", (Object)tableName, (Object)regions.size());
        Map targetServerNameByRegion = (Map)CallableTool.callUnchecked((Callable)balancer);
        for (DrRegionInfo drRegionInfo : regions) {
            drRegionInfo.setBalancerDestinationServer((ServerName)targetServerNameByRegion.get(drRegionInfo));
        }
        balancer.assertRegionCountsConsistent();
        return drRegionList;
    }

    private Map<HRegionInfo, ServerName> getServerNameByHRegionInfo(ClientId clientId, String tableName) {
        try {
            Connection connection = this.hBaseClientManager.getConnection(clientId);
            RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)tableName));
            Map<HRegionInfo, ServerName> serverNameByHRegionInfo = regionLocator.getAllRegionLocations().stream().collect(Collectors.toMap(HRegionLocation::getRegionInfo, HRegionLocation::getServerName));
            return serverNameByHRegionInfo;
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public static class DrRegionList {
        public static final String GROUP_BY_ALL = "all";
        private final List<DrRegionInfo<?>> regions;

        private DrRegionList(List<DrRegionInfo<?>> regions) {
            this.regions = regions;
        }

        public List<DrRegionInfo<?>> getRegions() {
            return this.regions;
        }

        public DrRegionInfo<?> getRegionByEncodedName(String encodedName) {
            for (DrRegionInfo<?> region : this.regions) {
                if (!region.getRegion().getEncodedName().equals(encodedName)) continue;
                return region;
            }
            return null;
        }

        public DrRegionInfo<?> getRegionAfter(String encodedName) {
            boolean foundFirstRegion = false;
            for (DrRegionInfo<?> region : this.regions) {
                if (foundFirstRegion) {
                    return region;
                }
                if (!region.getRegion().getEncodedName().equals(encodedName)) continue;
                foundFirstRegion = true;
            }
            return null;
        }

        private SortedMap<String, List<DrRegionInfo<?>>> getRegionsByServerName() {
            TreeMap out = new TreeMap();
            for (DrRegionInfo<?> region : this.regions) {
                String serverName = region.getServerName();
                if (out.get(serverName) == null) {
                    out.put(serverName, new LinkedList());
                }
                ((List)out.get(serverName)).add(region);
            }
            return out;
        }

        public LinkedHashMap<String, List<DrRegionInfo<?>>> getRegionsGroupedBy(String groupBy) {
            LinkedHashMap regionsByGroup = new LinkedHashMap();
            if (GROUP_BY_ALL.equals(groupBy)) {
                regionsByGroup.put(GROUP_BY_ALL, this.regions);
            } else if ("serverName".equals(groupBy)) {
                for (Map.Entry<String, List<DrRegionInfo<?>>> entry : this.getRegionsByServerName().entrySet()) {
                    regionsByGroup.put(entry.getKey(), entry.getValue());
                }
            }
            return regionsByGroup;
        }
    }
}

