/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.client;

import io.datarouter.storage.client.ClientId;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.client.Connection;

@Singleton
public class HBaseConnectionHolder {
    private final Map<ClientId, Connection> connectionsByClientId = new ConcurrentHashMap<ClientId, Connection>();

    public void register(ClientId clientId, Connection connection) {
        if (this.connectionsByClientId.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered a connection");
        }
        this.connectionsByClientId.put(clientId, connection);
    }

    public Connection getConnection(ClientId clientId) {
        return this.connectionsByClientId.get(clientId);
    }
}

