/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.model.field.Field;
import io.datarouter.model.key.entity.EntityKey;
import java.util.List;
import java.util.function.Supplier;

public class HBaseEntityKeyTool {
    public static <EK extends EntityKey<EK>> EK getEkFromRowBytes(byte[] rowBytes, Supplier<EK> entityKeySupplier, int numPrefixBytes, List<Field<?>> ekFields) {
        EntityKey ek = (EntityKey)entityKeySupplier.get();
        int byteOffset = numPrefixBytes;
        for (Field<?> field : ekFields) {
            if (byteOffset == rowBytes.length) break;
            Object value = field.fromKeyBytesWithSeparatorButDoNotSet(rowBytes, byteOffset);
            field.setUsingReflection((Object)ek, value);
            byteOffset += field.numKeyBytesWithSeparator(rowBytes, byteOffset);
        }
        return (EK)ek;
    }
}

