/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.web;

import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.HBaseClientType;
import io.datarouter.client.hbase.balancer.HBaseBalancerFactory;
import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.client.hbase.cluster.DrRegionListFactory;
import io.datarouter.client.hbase.cluster.DrServerInfo;
import io.datarouter.client.hbase.cluster.DrServerList;
import io.datarouter.client.hbase.cluster.DrTableSettings;
import io.datarouter.client.hbase.config.DatarouterHBaseFiles;
import io.datarouter.client.hbase.util.HBaseClientTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.util.concurrent.ThreadTool;
import io.datarouter.util.singletonsupplier.SingletonSupplier;
import io.datarouter.util.timer.PhaseTimer;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.types.optional.OptionalInteger;
import io.datarouter.web.handler.types.optional.OptionalLong;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.util.http.RequestTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(HBaseHandler.class);
    private static final String PARAM_PREFIX_encodedRegionName_ = "encodedRegionName_";
    private static final String HBASE_TABLE_PARAM_MAX_FILESIZE = "MAX_FILESIZE";
    private static final String HBASE_TABLE_PARAM_MEMSTORE_FLUSHSIZE = "MEMSTORE_FLUSHSIZE";
    @Inject
    private HBaseBalancerFactory balancerFactory;
    @Inject
    private DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory;
    @Inject
    private DatarouterHBaseFiles files;
    @Inject
    private DrRegionListFactory drRegionListFactory;
    @Inject
    private HBaseClientManager hBaseClientManager;
    private DatarouterWebRequestParamsFactory.DatarouterWebRequestParams<?> datarouterWebRequestParams;
    private int numRegions;
    private List<String> encodedRegionNameStrings;
    private Mav mav;
    private Supplier<DrServerList> drServerList;
    private Supplier<DrRegionListFactory.DrRegionList> regionList;

    private void initialize() {
        this.mav = new Mav();
        this.encodedRegionNameStrings = RequestTool.getCheckedBoxes((HttpServletRequest)this.request, (String)PARAM_PREFIX_encodedRegionName_);
        this.numRegions = this.encodedRegionNameStrings.size();
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.datarouterWebRequestParamsFactory;
        datarouterWebRequestParamsFactory.getClass();
        this.datarouterWebRequestParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, this.params, this.getClientType());
        this.mav.put("clientType", (Object)this.datarouterWebRequestParams.getClientType().getName());
        this.drServerList = SingletonSupplier.of(() -> new DrServerList(this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId())));
        this.regionList = SingletonSupplier.of(() -> this.drRegionListFactory.make(this.datarouterWebRequestParams.getClientId(), this.drServerList.get(), this.datarouterWebRequestParams.getTableName(), this.datarouterWebRequestParams.getPhysicalNode(), this.balancerFactory.getBalancerForTable(this.datarouterWebRequestParams.getClientId(), this.datarouterWebRequestParams.getTableName())));
    }

    protected Class<? extends ClientType<?, ?>> getClientType() {
        return HBaseClientType.class;
    }

    @BaseHandler.Handler
    public Mav viewHBaseServers() throws IOException {
        this.initialize();
        this.mav.setViewName(this.files.jsp.admin.datarouter.hbase.hbaseServersJsp);
        ClusterStatus clusterStatus = this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).getClusterStatus();
        this.mav.put("clusterStatus", (Object)clusterStatus);
        TreeSet serverNames = new TreeSet(clusterStatus.getServers());
        ArrayList<DrServerInfo> servers = new ArrayList<DrServerInfo>();
        for (ServerName serverName : serverNames) {
            ServerLoad serverLoad = clusterStatus.getLoad(serverName);
            servers.add(new DrServerInfo(serverName, serverLoad));
        }
        this.mav.put("servers", servers);
        return this.mav;
    }

    @BaseHandler.Handler
    public Mav viewHBaseTableSettings() throws TableNotFoundException, IOException {
        this.initialize();
        this.mav.setViewName(this.files.jsp.admin.datarouter.hbase.hbaseTableSettingsJsp);
        HTableDescriptor table = this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).getTableDescriptor(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
        TreeMap<String, String> tableParamByName = new TreeMap<String, String>();
        tableParamByName.put(HBASE_TABLE_PARAM_MAX_FILESIZE, String.valueOf(table.getMaxFileSize() / 1024L / 1024L));
        tableParamByName.put(HBASE_TABLE_PARAM_MEMSTORE_FLUSHSIZE, String.valueOf(table.getMemStoreFlushSize() / 1024L / 1024L));
        this.mav.put("tableParamByName", tableParamByName);
        List columnFamilies = Scanner.of((Object[])table.getColumnFamilies()).list();
        TreeMap<String, Map<String, String>> columnSummaryByName = new TreeMap<String, Map<String, String>>();
        for (HColumnDescriptor column : columnFamilies) {
            Map<String, String> attributeByName = HBaseHandler.parseFamilyAttributeMap(column.getValues());
            columnSummaryByName.put(column.getNameAsString(), attributeByName);
        }
        this.mav.put("columnSummaryByName", columnSummaryByName);
        this.mav.put("compressionOptions", DrTableSettings.COMPRESSION_STRINGS);
        this.mav.put("dataBlockEncodingOptions", DrTableSettings.DATA_BLOCK_ENCODING_STRINGS);
        this.mav.put("bloomOptions", DrTableSettings.BLOOMFILTER_STRINGS);
        return this.mav;
    }

    @BaseHandler.Handler
    public Mav viewHBaseTableRegions(OptionalString groupBy) {
        this.initialize();
        this.mav = new Mav(this.files.jsp.admin.datarouter.hbase.hbaseTableRegionsJsp);
        this.mav.put("regionsByGroup", this.regionList.get().getRegionsGroupedBy((String)groupBy.orElse((Object)"all")));
        this.mav.put("serverNames", this.drServerList.get().getServerNames());
        return this.mav;
    }

    @BaseHandler.Handler
    public Mav updateHBaseTableAttribute(OptionalLong maxFileSizeMb, OptionalLong memstoreFlushSizeMb) throws IOException {
        this.initialize();
        Admin admin = this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId());
        HTableDescriptor table = admin.getTableDescriptor(TableName.valueOf((byte[])this.datarouterWebRequestParams.getTableName().getBytes()));
        try {
            admin.disableTable(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
            logger.warn("table disabled");
            maxFileSizeMb.map(mb -> mb * 1024L * 1024L).ifPresent(arg_0 -> ((HTableDescriptor)table).setMaxFileSize(arg_0));
            memstoreFlushSizeMb.map(mb -> mb * 1024L * 1024L).ifPresent(arg_0 -> ((HTableDescriptor)table).setMemStoreFlushSize(arg_0));
            admin.modifyTable(TableName.valueOf((byte[])StringCodec.UTF_8.encode(this.datarouterWebRequestParams.getTableName())), (TableDescriptor)table);
        }
        finally {
            admin.enableTable(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
        }
        logger.warn("table enabled");
        this.mav = new MessageMav("HBase table attributes updated");
        return this.mav;
    }

    @BaseHandler.Handler
    public Mav updateHBaseColumnAttribute(String columnName) throws TableNotFoundException, IOException {
        block7: {
            this.initialize();
            Admin admin = this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId());
            HTableDescriptor table = admin.getTableDescriptor(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
            HColumnDescriptor column = table.getFamily(columnName.getBytes());
            try {
                try {
                    String value;
                    for (String colParam : DrTableSettings.COLUMN_SETTINGS) {
                        value = this.params.required(colParam);
                        DrTableSettings.validateColumnFamilySetting(colParam, value);
                    }
                    admin.disableTable(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
                    logger.warn("table disabled");
                    for (String colParam : DrTableSettings.COLUMN_SETTINGS) {
                        value = this.params.required(colParam);
                        column.setValue(colParam, value.trim());
                    }
                    admin.modifyColumn(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()), (ColumnFamilyDescriptor)column);
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                    admin.enableTable(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
                    break block7;
                }
            }
            catch (Throwable throwable) {
                admin.enableTable(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
                throw throwable;
            }
            admin.enableTable(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
        }
        this.mav = new MessageMav("HBase column attributes updated");
        return this.mav;
    }

    @BaseHandler.Handler
    public Mav moveRegionsToCorrectServer(OptionalInteger pauseBetweenRegionsMs) throws IOException {
        this.initialize();
        int counter = 0;
        for (DrRegionInfo<?> region : this.regionList.get().getRegions()) {
            if (!region.isOnCorrectServer()) {
                PhaseTimer timer = new PhaseTimer("move " + ++counter + " of " + this.datarouterWebRequestParams.getTableName());
                String encodedRegionNameString = region.getRegion().getEncodedName();
                String destinationServer = region.getConsistentHashServerName().getServerName();
                this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).move(Bytes.toBytes((String)encodedRegionNameString), Bytes.toBytes((String)destinationServer));
                logger.warn(timer.add("HBase moved region " + encodedRegionNameString + " to server " + destinationServer).toString());
            }
            ThreadTool.sleepUnchecked((long)((Integer)pauseBetweenRegionsMs.orElse((Object)500)).intValue());
        }
        return new MessageMav("HBase regions moved to correct server");
    }

    @BaseHandler.Handler
    public Mav moveHBaseTableRegions(String tableName, String destinationServerName) throws IOException {
        this.initialize();
        ServerName serverName = ServerName.valueOf((String)destinationServerName);
        if (!this.drServerList.get().getServerNames().contains(serverName)) {
            throw new IllegalArgumentException(serverName + " not found");
        }
        int i = 0;
        while (i < this.numRegions) {
            String encodedRegionNameString = this.encodedRegionNameStrings.get(i);
            PhaseTimer timer = new PhaseTimer("move " + i + "/" + this.numRegions + " of " + tableName);
            this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).move(Bytes.toBytes((String)encodedRegionNameString), Bytes.toBytes((String)destinationServerName));
            logger.warn(timer.add("HBase moved region " + encodedRegionNameString + " to server " + serverName).toString());
            ++i;
        }
        return new MessageMav("moved regions:" + this.encodedRegionNameStrings);
    }

    @BaseHandler.Handler
    public Mav compactHBaseTableRegions() throws IOException {
        this.initialize();
        for (String encodedRegionNameString : this.encodedRegionNameStrings) {
            DrRegionInfo<?> region = this.regionList.get().getRegionByEncodedName(encodedRegionNameString);
            this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).compactRegion(region.getRegion().getRegionName());
        }
        return new MessageMav("compactions requested for regions:" + this.encodedRegionNameStrings);
    }

    @BaseHandler.Handler
    public Mav compactAllHBaseTableRegions() throws IOException {
        this.initialize();
        this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).compact(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
        return new MessageMav("Submitted compact request for entire table " + this.datarouterWebRequestParams.getTableName());
    }

    @BaseHandler.Handler
    public Mav majorCompactHBaseTableRegions() throws IOException {
        this.initialize();
        for (String encodedRegionNameString : this.encodedRegionNameStrings) {
            DrRegionInfo<?> region = this.regionList.get().getRegionByEncodedName(encodedRegionNameString);
            this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).majorCompactRegion(region.getRegion().getRegionName());
        }
        return new MessageMav("submitted major compaction requests for regions: " + this.encodedRegionNameStrings);
    }

    @BaseHandler.Handler
    public Mav majorCompactAllHBaseTableRegions() throws IOException {
        this.initialize();
        this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).majorCompact(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
        return new MessageMav("Submitted majorCompact request for entire table " + this.datarouterWebRequestParams.getTableName());
    }

    @BaseHandler.Handler
    public Mav flushHBaseTableRegions() throws IOException {
        this.initialize();
        for (String encodedRegionNameString : this.encodedRegionNameStrings) {
            DrRegionInfo<?> region = this.regionList.get().getRegionByEncodedName(encodedRegionNameString);
            this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).flushRegion(region.getRegion().getRegionName());
        }
        return new MessageMav("flushes requested for regions: " + this.encodedRegionNameStrings);
    }

    @BaseHandler.Handler
    public Mav flushAllHBaseTableRegions() throws IOException {
        this.initialize();
        this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).flush(TableName.valueOf((String)this.datarouterWebRequestParams.getTableName()));
        return new MessageMav("Flushed all table regions ");
    }

    @BaseHandler.Handler
    public Mav splitPartitions() throws Exception {
        byte[][] splitPoints;
        this.initialize();
        TableName tableName = TableName.valueOf((String)this.datarouterWebRequestParams.getTableName());
        byte[][] byArray = splitPoints = HBaseClientTool.getSplitPoints(NodeTool.extractSinglePhysicalNode((Node)this.datarouterWebRequestParams.getNode()));
        int n = splitPoints.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] splitPoint = byArray[n2];
            try {
                this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).split(tableName, splitPoint);
            }
            catch (IOException e) {
                if (e.getMessage().equals("should not give a splitkey which equals to startkey!")) {
                    logger.warn("split at {} already exists", (Object)Bytes.toStringBinary((byte[])splitPoint), (Object)e);
                }
                throw e;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        List infos = this.hBaseClientManager.getAdmin(this.datarouterWebRequestParams.getClientId()).getTableRegions(tableName);
        byte[][] byArray2 = splitPoints;
        int n3 = splitPoints.length;
        n = 0;
        while (n < n3) {
            byte[] splitPoint = byArray2[n];
            boolean containsRegion = false;
            for (HRegionInfo info : infos) {
                if (!Arrays.equals(info.getStartKey(), splitPoint)) continue;
                containsRegion = true;
            }
            if (!containsRegion) {
                throw new Exception("Regions were not split properly splitPoint=" + Bytes.toStringBinary((byte[])splitPoint));
            }
            ++n;
        }
        return new MessageMav("Split regions by partitions");
    }

    private static Map<String, String> parseFamilyAttributeMap(Map<Bytes, Bytes> ins) {
        TreeMap<String, String> outs = new TreeMap<String, String>();
        for (Map.Entry<Bytes, Bytes> entry : ins.entrySet()) {
            outs.put(StringCodec.UTF_8.decode(entry.getKey().get()), StringCodec.UTF_8.decode(entry.getValue().get()));
        }
        if (!outs.containsKey("DATA_BLOCK_ENCODING")) {
            outs.put("DATA_BLOCK_ENCODING", "NONE");
        }
        if (!outs.containsKey("ENCODE_ON_DISK")) {
            outs.put("ENCODE_ON_DISK", "true");
        }
        return outs;
    }
}

