/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.balancer.imp;

import io.datarouter.client.hbase.balancer.BaseHBaseRegionBalancer;
import io.datarouter.client.hbase.balancer.HBaseBalanceLeveler;
import io.datarouter.client.hbase.balancer.imp.ConsistentHashBalancer;
import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.util.Require;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ServerName;

public class EntityPartitionBalancer
extends BaseHBaseRegionBalancer {
    private Map<Integer, List<DrRegionInfo<?>>> regionsByPartition;

    public EntityPartitionBalancer(String tableName) {
        super(tableName);
    }

    @Override
    public SortedMap<DrRegionInfo<?>, ServerName> call() {
        this.initRegionByPartitionMap();
        SortedMap<Long, ServerName> consistentHashRing = ConsistentHashBalancer.buildServerHashRing(this.drhServerList, ConsistentHashBalancer.BUCKETS_PER_NODE);
        SortedMap<Integer, Object> serverByPartition = new TreeMap();
        for (Integer partition : this.regionsByPartition.keySet()) {
            byte[] consistentHashInput = this.entityPartitioner.getPrefix(partition.intValue());
            ServerName serverName = ConsistentHashBalancer.calcServerNameForItem(consistentHashRing, consistentHashInput);
            serverByPartition.put(partition, serverName);
        }
        HBaseBalanceLeveler leveler = new HBaseBalanceLeveler(this.drhServerList.getServerNames(), serverByPartition, this.tableName);
        serverByPartition = leveler.getBalancedDestinationByItem();
        for (Map.Entry entry : serverByPartition.entrySet()) {
            List<DrRegionInfo<?>> regionsInPartition = this.regionsByPartition.get(entry.getKey());
            for (DrRegionInfo<?> region : regionsInPartition) {
                this.serverByRegion.put(region, (ServerName)entry.getValue());
            }
        }
        this.assertRegionCountsConsistent();
        return this.serverByRegion;
    }

    private void initRegionByPartitionMap() {
        this.regionsByPartition = new TreeMap();
        for (Integer n : this.entityPartitioner.getAllPartitions()) {
            this.regionsByPartition.put(n, new ArrayList());
        }
        for (DrRegionInfo drRegionInfo : this.drhRegionList.getRegions()) {
            Integer partition = drRegionInfo.getPartition();
            if (partition == null) {
                partition = 0;
            }
            Require.isTrue((boolean)this.regionsByPartition.containsKey(partition), (String)("partition " + partition + " not found"));
            this.regionsByPartition.get(partition).add(drRegionInfo);
        }
    }
}

