/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.balancer;

import io.datarouter.client.hbase.cluster.DrRegionInfo;
import io.datarouter.client.hbase.cluster.DrRegionListFactory;
import io.datarouter.client.hbase.cluster.DrServerList;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.util.string.StringTool;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.ServerName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHBaseRegionBalancer
implements Callable<Map<DrRegionInfo<?>, ServerName>> {
    private static final Logger logger = LoggerFactory.getLogger(BaseHBaseRegionBalancer.class);
    protected final String tableName;
    protected DrServerList drhServerList;
    protected DrRegionListFactory.DrRegionList drhRegionList;
    protected SortedMap<DrRegionInfo<?>, ServerName> serverByRegion;
    protected EntityPartitioner<?> entityPartitioner;

    protected BaseHBaseRegionBalancer(String tableName) {
        this.tableName = tableName;
    }

    public BaseHBaseRegionBalancer init(EntityPartitioner<?> entityPartitioner, DrServerList drhServerList, DrRegionListFactory.DrRegionList drhRegionList) {
        this.entityPartitioner = entityPartitioner;
        this.drhServerList = drhServerList;
        this.drhRegionList = drhRegionList;
        this.serverByRegion = new TreeMap();
        return this;
    }

    public void assertRegionCountsConsistent() {
        if (this.drhRegionList.getRegions().size() != this.serverByRegion.size()) {
            logger.error("regions:" + this.drhRegionList.getRegions());
            logger.error("balanced regions:" + this.serverByRegion.keySet());
            throw new RuntimeException("region count mismatch: input=" + this.drhRegionList.getRegions().size() + ", output=" + this.serverByRegion.size());
        }
    }

    protected String getServerByRegionStringForDebug() {
        int idx = 0;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<DrRegionInfo<?>, ServerName> entry : this.serverByRegion.entrySet()) {
            sb.append("\n" + StringTool.pad((String)String.valueOf(idx), (char)' ', (int)3) + " " + entry.getKey().getRegion().getEncodedName() + ", " + entry.getValue());
            ++idx;
        }
        return sb.toString();
    }
}

