/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.client;

import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.gcp.bigtable.client.BigTableCredentials;
import io.datarouter.gcp.bigtable.client.BigTableOptions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BigTableClientManager
extends HBaseClientManager {
    private static final Logger logger = LoggerFactory.getLogger(BigTableClientManager.class);
    @Inject
    private BigTableOptions bigTableOptions;

    public boolean monitorLatency() {
        return false;
    }

    protected Connection makeConnection(String clientName) {
        String projectId = this.bigTableOptions.projectId(clientName);
        String instanceId = this.bigTableOptions.instanceId(clientName);
        Configuration config = BigtableConfiguration.configure((String)projectId, (String)instanceId);
        BigTableCredentials credentials = this.bigTableOptions.bigtableConfigurationCredentialsKeyValue(clientName);
        logger.warn("connecting to bigtable projectId={} instanceId={} credsType={}", new Object[]{projectId, instanceId, credentials.key()});
        config.set(credentials.key(), credentials.value());
        return BigtableConfiguration.connect((Configuration)config);
    }
}

