/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.client;

import io.datarouter.client.hbase.client.HBaseClientOptionsBuilder;
import io.datarouter.gcp.bigtable.client.BigTableOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.client.BigtableGenericClientOptions;
import java.util.Optional;
import java.util.Properties;

public class BigTableClientOptionsBuilder
extends HBaseClientOptionsBuilder {
    public BigTableClientOptionsBuilder(ClientId clientId) {
        super(clientId, "bigtable");
    }

    public BigTableClientOptionsBuilder(BigtableGenericClientOptions genericOptions) {
        this(genericOptions.clientId);
        this.withProjectId(genericOptions.projectId);
        this.withInstanceId(genericOptions.instanceId);
        Optional.ofNullable(genericOptions.credentialsFileLocation).ifPresent(this::withCredentialsFileLocation);
        Optional.ofNullable(genericOptions.credentialsSecretLocation).ifPresent(this::withCredentialsSecretLocation);
    }

    public BigTableClientOptionsBuilder withProjectId(String projectId) {
        String optionKeySuffix = BigTableOptions.makeBigtableKey("projectId");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, projectId);
        return this;
    }

    public BigTableClientOptionsBuilder withInstanceId(String instanceId) {
        String optionKeySuffix = BigTableOptions.makeBigtableKey("instanceId");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, instanceId);
        return this;
    }

    public BigTableClientOptionsBuilder withCredentialsFileLocation(String credentialsFileLocation) {
        String optionKeySuffix = BigTableOptions.makeBigtableKey("credentialsFileLocation");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, credentialsFileLocation);
        return this;
    }

    public BigTableClientOptionsBuilder withCredentialsSecretLocation(String credentialsSecretLocation) {
        String optionKeySuffix = BigTableOptions.makeBigtableKey("credentialsSecretLocation");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, credentialsSecretLocation);
        return this;
    }

    public Properties build() {
        return this.properties;
    }
}

