/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.client;

import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.gcp.bigtable.client.BigTableOptions;
import io.datarouter.util.tuple.Twin;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;

@Singleton
public class BigTableClientManager
extends HBaseClientManager {
    @Inject
    private BigTableOptions bigTableOptions;

    public boolean monitorLatency() {
        return false;
    }

    protected Connection makeConnection(String clientName) {
        String projectId = this.bigTableOptions.projectId(clientName);
        String instanceId = this.bigTableOptions.instanceId(clientName);
        Configuration config = BigtableConfiguration.configure((String)projectId, (String)instanceId);
        Twin<String> credentialsKeyValue = this.bigTableOptions.bigtableConfigurationCredentialsKeyValue(clientName);
        config.set((String)credentialsKeyValue.getLeft(), (String)credentialsKeyValue.getRight());
        return BigtableConfiguration.connect((Configuration)config);
    }
}

