/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.writer;

import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.util.Count;
import io.datarouter.util.number.NumberFormatter;

public class SnapshotWriterTracker {
    private final SnapshotKey snapshotKey;
    private final Count.Counts counts = new Count.Counts();
    public final Count entriesProcessed = this.counts.add("entriesProcessed");
    public final Count entriesQueued = this.counts.add("entriesQueued");
    public final Count readStallNs = this.counts.add("readStallNs");
    public final Count valueStallNs = this.counts.add("valueStallNs");
    public final Count leafStallNs = this.counts.add("leafStallNs");
    public final Count valueTasks = this.counts.add("valueTasks");
    public final Count leafTasks = this.counts.add("leafTasks");
    public final Count branchTasks = this.counts.add("branchTasks");
    public final Count valueBlocks = this.counts.add("valueBlocks");
    public final Count leafBlocks = this.counts.add("leafBlocks");
    public final Count branchBlocks = this.counts.add("branchBlocks");
    public final Count valueBytesEncoded = this.counts.add("valueBytesEncoded");
    public final Count leafBytesEncoded = this.counts.add("leafBytesEncoded");
    public final Count branchBytesEncoded = this.counts.add("branchBytesEncoded");
    public final Count valueBytesCompressed = this.counts.add("valueBytesCompressed");
    public final Count leafBytesCompressed = this.counts.add("leafBytesCompressed");
    public final Count branchBytesCompressed = this.counts.add("branchBytesCompressed");
    public final Count valueBlocksInMemory = this.counts.add("valueBlocksInMemory");
    public final Count leafBlocksInMemory = this.counts.add("leafBlocksInMemory");
    public final Count branchBlocksInMemory = this.counts.add("branchBlocksInMemory");
    public final Count valueBytesInMemory = this.counts.add("valueBytesInMemory");
    public final Count leafBytesInMemory = this.counts.add("leafBytesInMemory");
    public final Count branchBytesInMemory = this.counts.add("branchBytesInMemory");

    public SnapshotWriterTracker(SnapshotKey snapshotKey) {
        this.snapshotKey = snapshotKey;
    }

    public long totalTasks() {
        return this.valueTasks.value() + this.leafTasks.value() + this.branchTasks.value();
    }

    public void valueBlock(EncodedBlock encodedBlock, CompressedBlock compressedBlock) {
        this.valueBlocks.increment();
        this.valueBytesEncoded.incrementBy((long)encodedBlock.totalLength);
        this.valueBytesCompressed.incrementBy((long)compressedBlock.totalLength);
    }

    public void leafBlock(EncodedBlock encodedBlock, CompressedBlock compressedBlock) {
        this.leafBlocks.increment();
        this.leafBytesEncoded.incrementBy((long)encodedBlock.totalLength);
        this.leafBytesCompressed.incrementBy((long)compressedBlock.totalLength);
    }

    public void branchBlock(EncodedBlock encodedBlock, CompressedBlock compressedBlock) {
        this.branchBlocks.increment();
        this.branchBytesEncoded.incrementBy((long)encodedBlock.totalLength);
        this.branchBytesCompressed.incrementBy((long)compressedBlock.totalLength);
    }

    public void valueMemory(boolean increment, int numBlocks, long numBytes) {
        if (increment) {
            this.valueBlocksInMemory.incrementBy((long)numBlocks);
            this.valueBytesInMemory.incrementBy(numBytes);
        } else {
            this.valueBlocksInMemory.decrementBy((long)numBlocks);
            this.valueBytesInMemory.decrementBy(numBytes);
        }
    }

    public void leafMemory(boolean increment, int numBlocks, long numBytes) {
        if (increment) {
            this.leafBlocksInMemory.incrementBy((long)numBlocks);
            this.leafBytesInMemory.incrementBy(numBytes);
        } else {
            this.leafBlocksInMemory.decrementBy((long)numBlocks);
            this.leafBytesInMemory.decrementBy(numBytes);
        }
    }

    public void branchMemory(boolean increment, int numBlocks, long numBytes) {
        if (increment) {
            this.branchBlocksInMemory.incrementBy((long)numBlocks);
            this.branchBytesInMemory.incrementBy(numBytes);
        } else {
            this.branchBlocksInMemory.decrementBy((long)numBlocks);
            this.branchBytesInMemory.decrementBy(numBytes);
        }
    }

    public String toLog(long elapsedMs) {
        long elapsedNs = elapsedMs * 1000000L;
        double elapsedSeconds = (double)elapsedMs / 1000.0;
        double readStallNsDbl = this.readStallNs.value();
        double valueStallNsDbl = this.valueStallNs.value();
        double leafStallNsDbl = this.leafStallNs.value();
        double itemsPerSecDbl = (double)this.entriesProcessed.value() / elapsedSeconds;
        int readStallPct = (int)(readStallNsDbl / (double)elapsedNs * 100.0);
        int valueStallPct = (int)(valueStallNsDbl / (double)elapsedNs * 100.0);
        int leafStallPct = (int)(leafStallNsDbl / (double)elapsedNs * 100.0);
        long itemsPerSec = (long)itemsPerSecDbl;
        return String.format("group=%s, id=%s, readStall=%s%%, valueStall=%s%%, leafStall=%s%%, itemsPerSec=%s, %s", this.snapshotKey.groupId, this.snapshotKey.snapshotId, readStallPct, valueStallPct, leafStallPct, NumberFormatter.addCommas((Number)itemsPerSec), this.counts);
    }
}

