/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.writer;

import io.datarouter.filesystem.snapshot.block.branch.BranchBlockV1Encoder;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlockV1Encoder;
import io.datarouter.filesystem.snapshot.block.root.RootBlockV1Encoder;
import io.datarouter.filesystem.snapshot.block.value.ValueBlockV1Encoder;
import io.datarouter.filesystem.snapshot.compress.BlockCompressor;
import io.datarouter.filesystem.snapshot.compress.PassthroughBlockCompressor;
import io.datarouter.filesystem.snapshot.encode.BranchBlockEncoder;
import io.datarouter.filesystem.snapshot.encode.LeafBlockEncoder;
import io.datarouter.filesystem.snapshot.encode.RootBlockEncoder;
import io.datarouter.filesystem.snapshot.encode.ValueBlockEncoder;
import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.path.SnapshotPathsV1;
import io.datarouter.filesystem.snapshot.writer.SnapshotWriterConfig;
import java.util.function.Function;
import java.util.function.Supplier;

public class SnapshotWriterConfigBuilder {
    private static final int DEFAULT_BATCH_QUEUE_LENGTH = 100;
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_LOG_PERIOD_MS = 1000;
    private static final boolean DEFAULT_COMPRESSOR_CONCAT_CHUNKS = false;
    private static final boolean DEFAULT_PERSIST = true;
    private static final boolean DEFAULT_UPDATE_CACHE = false;
    private static final int DEFAULT_LEAF_ENCODER_CHUNK_SIZE = 32768;
    private static final int DEFAULT_BYTES_PER_BLOCK = 32768;
    private static final int DEFAULT_BYTES_PER_FILE = 0x4000000;
    private static final int DEFAULT_BLOCKS_PER_FILE = 10000;
    private boolean sorted;
    private final int numColumns;
    private int batchQueueLength;
    private int numThreads;
    private long logPeriodMs;
    private boolean compressorConcatChunks;
    private boolean persist;
    private boolean updateCache;
    private Supplier<SnapshotPaths> pathsSupplier;
    private int leafEncoderChunkSize;
    private int branchBlockSize;
    private int leafBlockSize;
    private int valueBlockSize;
    private int branchBytesPerFile;
    private int leafBytesPerFile;
    private int valueBytesPerFile;
    private int branchBlocksPerFile;
    private int leafBlocksPerFile;
    private int valueBlocksPerFile;
    private Supplier<RootBlockEncoder> rootBlockEncoderSupplier;
    private Function<Integer, BranchBlockEncoder> branchBlockEncoderFactory;
    private Supplier<LeafBlockEncoder> leafBlockEncoderSupplier;
    private Supplier<ValueBlockEncoder> valueBlockEncoderSupplier;
    private BlockCompressor branchBlockCompressor;
    private BlockCompressor leafBlockCompressor;
    private BlockCompressor valueBlockCompressor;

    public SnapshotWriterConfigBuilder(boolean sorted, int numColumns) {
        this.sorted = sorted;
        this.numColumns = numColumns;
        this.batchQueueLength = 100;
        this.numThreads = DEFAULT_NUM_THREADS;
        this.logPeriodMs = 1000L;
        this.compressorConcatChunks = false;
        this.persist = true;
        this.updateCache = false;
        this.pathsSupplier = SnapshotPathsV1::new;
        this.leafEncoderChunkSize = 32768;
        this.branchBlockSize = 32768;
        this.leafBlockSize = 32768;
        this.valueBlockSize = 32768;
        this.branchBytesPerFile = 0x4000000;
        this.leafBytesPerFile = 0x4000000;
        this.valueBytesPerFile = 0x4000000;
        this.branchBlocksPerFile = 10000;
        this.leafBlocksPerFile = 10000;
        this.valueBlocksPerFile = 10000;
        this.rootBlockEncoderSupplier = () -> new RootBlockV1Encoder();
        this.branchBlockEncoderFactory = level -> new BranchBlockV1Encoder((int)level);
        this.leafBlockEncoderSupplier = () -> new LeafBlockV1Encoder(this.leafEncoderChunkSize);
        this.valueBlockEncoderSupplier = () -> new ValueBlockV1Encoder();
        this.branchBlockCompressor = new PassthroughBlockCompressor();
        this.leafBlockCompressor = new PassthroughBlockCompressor();
        this.valueBlockCompressor = new PassthroughBlockCompressor();
    }

    public SnapshotWriterConfigBuilder withBatchQueueLength(int batchQueueLength) {
        this.batchQueueLength = batchQueueLength;
        return this;
    }

    public SnapshotWriterConfigBuilder withNumThreads(int numThreads) {
        this.numThreads = numThreads;
        return this;
    }

    public SnapshotWriterConfigBuilder withLogPeriodThreads(int logPeriodMs) {
        this.logPeriodMs = logPeriodMs;
        return this;
    }

    public SnapshotWriterConfigBuilder withCompressorConcatChunks(boolean compressorConcatChunks) {
        this.compressorConcatChunks = compressorConcatChunks;
        return this;
    }

    public SnapshotWriterConfigBuilder withPersist(boolean persist) {
        this.persist = persist;
        return this;
    }

    public SnapshotWriterConfigBuilder withUpdateCache(boolean updateCache) {
        this.updateCache = updateCache;
        return this;
    }

    public SnapshotWriterConfigBuilder withPathsSupplier(Supplier<SnapshotPaths> pathsSupplier) {
        this.pathsSupplier = pathsSupplier;
        return this;
    }

    public SnapshotWriterConfigBuilder withLeafEncoderChunkSize(int leafEncoderChunkSize) {
        this.leafEncoderChunkSize = leafEncoderChunkSize;
        return this;
    }

    public SnapshotWriterConfigBuilder withBlockSize(int blockSize) {
        this.branchBlockSize = blockSize;
        this.leafBlockSize = blockSize;
        this.valueBlockSize = blockSize;
        return this;
    }

    public SnapshotWriterConfigBuilder withBranchBlockSize(int branchBlockSize) {
        this.branchBlockSize = branchBlockSize;
        return this;
    }

    public SnapshotWriterConfigBuilder withLeafBlockSize(int leafBlockSize) {
        this.leafBlockSize = leafBlockSize;
        return this;
    }

    public SnapshotWriterConfigBuilder withValueBlockSize(int valueBlockSize) {
        this.valueBlockSize = valueBlockSize;
        return this;
    }

    public SnapshotWriterConfigBuilder withBytesPerFile(int bytesPerFile) {
        this.branchBytesPerFile = bytesPerFile;
        this.leafBytesPerFile = bytesPerFile;
        this.valueBytesPerFile = bytesPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withBranchBytesPerFile(int branchBytesPerFile) {
        this.branchBytesPerFile = branchBytesPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withLeafBytesPerFile(int leafBytesPerFile) {
        this.leafBytesPerFile = leafBytesPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withValueBytesPerFile(int valueBytesPerFile) {
        this.valueBytesPerFile = valueBytesPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withBlocksPerFile(int blocksPerFile) {
        this.branchBlocksPerFile = blocksPerFile;
        this.leafBlocksPerFile = blocksPerFile;
        this.valueBlocksPerFile = blocksPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withBranchBlocksPerFile(int branchBlocksPerFile) {
        this.branchBlocksPerFile = branchBlocksPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withLeafBlocksPerFile(int leafBlocksPerFile) {
        this.leafBlocksPerFile = leafBlocksPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withValueBlocksPerFile(int valueBlocksPerFile) {
        this.valueBlocksPerFile = valueBlocksPerFile;
        return this;
    }

    public SnapshotWriterConfigBuilder withRootBlockEncoderFactory(Supplier<RootBlockEncoder> rootBlockEncoderSupplier) {
        this.rootBlockEncoderSupplier = rootBlockEncoderSupplier;
        return this;
    }

    public SnapshotWriterConfigBuilder withBranchBlockEncoderFactory(Function<Integer, BranchBlockEncoder> branchEncoderFactory) {
        this.branchBlockEncoderFactory = branchEncoderFactory;
        return this;
    }

    public SnapshotWriterConfigBuilder withLeafBlockEncoderSupplier(Supplier<LeafBlockEncoder> leafBlockEncoderSupplier) {
        this.leafBlockEncoderSupplier = leafBlockEncoderSupplier;
        return this;
    }

    public SnapshotWriterConfigBuilder withValueBlockEncoderSupplier(Supplier<ValueBlockEncoder> valueBlockEncoderSupplier) {
        this.valueBlockEncoderSupplier = valueBlockEncoderSupplier;
        return this;
    }

    public SnapshotWriterConfigBuilder withCompressor(BlockCompressor compressor) {
        this.branchBlockCompressor = compressor;
        this.leafBlockCompressor = compressor;
        this.valueBlockCompressor = compressor;
        return this;
    }

    public SnapshotWriterConfigBuilder withBranchBlockCompressor(BlockCompressor branchBlockCompressor) {
        this.branchBlockCompressor = branchBlockCompressor;
        return this;
    }

    public SnapshotWriterConfigBuilder withLeafBlockCompressor(BlockCompressor leafBlockCompressor) {
        this.leafBlockCompressor = leafBlockCompressor;
        return this;
    }

    public SnapshotWriterConfigBuilder withValueBlockCompressor(BlockCompressor valueBlockCompressor) {
        this.valueBlockCompressor = valueBlockCompressor;
        return this;
    }

    public SnapshotWriterConfig build() {
        return new SnapshotWriterConfig(this.sorted, this.numColumns, this.batchQueueLength, this.numThreads, this.logPeriodMs, this.compressorConcatChunks, this.persist, this.updateCache, this.pathsSupplier, this.leafEncoderChunkSize, this.branchBlockSize, this.leafBlockSize, this.valueBlockSize, this.branchBytesPerFile, this.leafBytesPerFile, this.valueBytesPerFile, this.branchBlocksPerFile, this.leafBlocksPerFile, this.valueBlocksPerFile, this.rootBlockEncoderSupplier, this.branchBlockEncoderFactory, this.leafBlockEncoderSupplier, this.valueBlockEncoderSupplier, this.branchBlockCompressor, this.leafBlockCompressor, this.valueBlockCompressor);
    }
}

